<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSipTrunkDestination StructType
 * @subpackage Structs
 */
class LSipTrunkDestination extends AbstractStructBase
{
    /**
     * The addressIpv4
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $addressIpv4;
    /**
     * The addressIpv6
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $addressIpv6;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $port;
    /**
     * The sortOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sortOrder;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LSipTrunkDestination
     * @uses LSipTrunkDestination::setAddressIpv4()
     * @uses LSipTrunkDestination::setAddressIpv6()
     * @uses LSipTrunkDestination::setPort()
     * @uses LSipTrunkDestination::setSortOrder()
     * @uses LSipTrunkDestination::setUuid()
     * @param string $addressIpv4
     * @param string $addressIpv6
     * @param string $port
     * @param string $sortOrder
     * @param string $uuid
     */
    public function __construct($addressIpv4 = null, $addressIpv6 = null, $port = null, $sortOrder = null, $uuid = null)
    {
        $this
            ->setAddressIpv4($addressIpv4)
            ->setAddressIpv6($addressIpv6)
            ->setPort($port)
            ->setSortOrder($sortOrder)
            ->setUuid($uuid);
    }
    /**
     * Get addressIpv4 value
     * @return string|null
     */
    public function getAddressIpv4()
    {
        return $this->addressIpv4;
    }
    /**
     * Set addressIpv4 value
     * @param string $addressIpv4
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkDestination
     */
    public function setAddressIpv4($addressIpv4 = null)
    {
        // validation for constraint: string
        if (!is_null($addressIpv4) && !is_string($addressIpv4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressIpv4, true), gettype($addressIpv4)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($addressIpv4) && mb_strlen($addressIpv4) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($addressIpv4)), __LINE__);
        }
        $this->addressIpv4 = $addressIpv4;
        return $this;
    }
    /**
     * Get addressIpv6 value
     * @return string|null
     */
    public function getAddressIpv6()
    {
        return $this->addressIpv6;
    }
    /**
     * Set addressIpv6 value
     * @param string $addressIpv6
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkDestination
     */
    public function setAddressIpv6($addressIpv6 = null)
    {
        // validation for constraint: string
        if (!is_null($addressIpv6) && !is_string($addressIpv6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressIpv6, true), gettype($addressIpv6)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($addressIpv6) && mb_strlen($addressIpv6) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($addressIpv6)), __LINE__);
        }
        $this->addressIpv6 = $addressIpv6;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkDestination
     */
    public function setPort($port = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($port) ? implode(', ', $port) : var_export($port, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get sortOrder value
     * @return string|null
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortOrder
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkDestination
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($sortOrder) ? implode(', ', $sortOrder) : var_export($sortOrder, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkDestination
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
