<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSipTrunk StructType
 * @subpackage Structs
 */
class LSipTrunk extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta information extracted from the WSDL
     * - documentation: Model ID string. Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The networkHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The packetCaptureMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The loadInformation
     * Meta information extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The traceFlag
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The securityProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $securityProfileName;
    /**
     * The sipProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipProfileName;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The sendGeoLocation
     * Meta information extracted from the WSDL
     * - documentation: Not valid for CTI route points and VoiceMail ports
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendGeoLocation;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The unattendedPort
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for H323Phones and H323Trunks.Not for Gateways.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The transmitUtf8
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The rerouteCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $rerouteCallingSearchSpaceName;
    /**
     * The referCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $referCallingSearchSpaceName;
    /**
     * The mtpRequired
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mtpRequired;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The unknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $unknownPrefix;
    /**
     * The destAddrIsSrv
     * Meta information extracted from the WSDL
     * - documentation: This tag is ignored and destAddrIsSRV is set to false if destinationaddress is an IP address and destinationport is mentioned correctly.This tag will not be returned by list.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $destAddrIsSrv;
    /**
     * The tkSipCodec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tkSipCodec;
    /**
     * The sigDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\SigDigits
     */
    public $sigDigits;
    /**
     * The connectedNamePresentation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedNamePresentation;
    /**
     * The connectedPartyIdPresentation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedPartyIdPresentation;
    /**
     * The callingPartySelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingname;
    /**
     * The callingLineIdPresentation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingLineIdPresentation;
    /**
     * The prefixDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefixDn;
    /**
     * The callerName
     * Meta information extracted from the WSDL
     * - documentation: Characters which are not valid for caller name are ampersand, braces, less than or greater than, percentage sign, double quotes, square brackets and pipe.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerName;
    /**
     * The callerIdDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerIdDn;
    /**
     * The acceptInboundRdnis
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptInboundRdnis;
    /**
     * The acceptOutboundRdnis
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptOutboundRdnis;
    /**
     * The srtpAllowed
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpAllowed;
    /**
     * The srtpFallbackAllowed
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only if srtpAllowed is set to false.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpFallbackAllowed;
    /**
     * The isPaiEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPaiEnabled;
    /**
     * The sipPrivacy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipPrivacy;
    /**
     * The isRpidEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isRpidEnabled;
    /**
     * The sipAssertedType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipAssertedType;
    /**
     * The dtmfSignalingMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dtmfSignalingMethod;
    /**
     * The routeClassSignalling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routeClassSignalling;
    /**
     * The sipTrunkType
     * Meta information extracted from the WSDL
     * - documentation: This tag is not supported in the Update method.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipTrunkType;
    /**
     * The pstnAccess
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $imeE164TransformationName;
    /**
     * The useImePublicIpPort
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useImePublicIpPort;
    /**
     * The useDevicePoolCntdPnTransformationCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCntdPnTransformationCss;
    /**
     * The useDevicePoolCgpnTransformCssUnkn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnkn;
    /**
     * The sipNormalizationScriptName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipNormalizationScriptName;
    /**
     * The runOnEveryNode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $runOnEveryNode;
    /**
     * The unknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $unknownStripDigits;
    /**
     * The cgpnTransformationUnknownCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationUnknownCssName;
    /**
     * The tunneledProtocol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tunneledProtocol;
    /**
     * The asn1RoseOidEncoding
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $asn1RoseOidEncoding;
    /**
     * The qsigVariant
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $qsigVariant;
    /**
     * The pathReplacementSupport
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pathReplacementSupport;
    /**
     * The enableQsigUtf8
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableQsigUtf8;
    /**
     * The scriptParameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $scriptParameters;
    /**
     * The scriptTraceEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $scriptTraceEnabled;
    /**
     * The trunkTrafficSecure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkTrafficSecure;
    /**
     * The callingAndCalledPartyInfoFormat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingAndCalledPartyInfoFormat;
    /**
     * The useCallerIdCallerNameinUriOutgoingRequest
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useCallerIdCallerNameinUriOutgoingRequest;
    /**
     * The requestUriDomainName
     * Meta information extracted from the WSDL
     * - documentation: Valid only for IP Multimedia Subsystem Service Control (ISC) Sip trunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $requestUriDomainName;
    /**
     * The enableCiscoRecordingQsigTunneling
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableCiscoRecordingQsigTunneling;
    /**
     * The calledPartyUnknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartyUnknownTransformationCssName;
    /**
     * The calledPartyUnknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyUnknownPrefix;
    /**
     * The calledPartyUnknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyUnknownStripDigits;
    /**
     * The useDevicePoolCalledCssUnkn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssUnkn;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LSipTrunk
     * @uses LSipTrunk::setName()
     * @uses LSipTrunk::setDescription()
     * @uses LSipTrunk::setProduct()
     * @uses LSipTrunk::setModel()
     * @uses LSipTrunk::setClass()
     * @uses LSipTrunk::setProtocol()
     * @uses LSipTrunk::setProtocolSide()
     * @uses LSipTrunk::setCallingSearchSpaceName()
     * @uses LSipTrunk::setDevicePoolName()
     * @uses LSipTrunk::setCommonDeviceConfigName()
     * @uses LSipTrunk::setNetworkLocation()
     * @uses LSipTrunk::setLocationName()
     * @uses LSipTrunk::setMediaResourceListName()
     * @uses LSipTrunk::setNetworkHoldMohAudioSourceId()
     * @uses LSipTrunk::setUserHoldMohAudioSourceId()
     * @uses LSipTrunk::setAutomatedAlternateRoutingCssName()
     * @uses LSipTrunk::setAarNeighborhoodName()
     * @uses LSipTrunk::setPacketCaptureMode()
     * @uses LSipTrunk::setPacketCaptureDuration()
     * @uses LSipTrunk::setLoadInformation()
     * @uses LSipTrunk::setTraceFlag()
     * @uses LSipTrunk::setMlppIndicationStatus()
     * @uses LSipTrunk::setPreemption()
     * @uses LSipTrunk::setUseTrustedRelayPoint()
     * @uses LSipTrunk::setRetryVideoCallAsAudio()
     * @uses LSipTrunk::setSecurityProfileName()
     * @uses LSipTrunk::setSipProfileName()
     * @uses LSipTrunk::setCgpnTransformationCssName()
     * @uses LSipTrunk::setUseDevicePoolCgpnTransformCss()
     * @uses LSipTrunk::setGeoLocationName()
     * @uses LSipTrunk::setGeoLocationFilterName()
     * @uses LSipTrunk::setSendGeoLocation()
     * @uses LSipTrunk::setCdpnTransformationCssName()
     * @uses LSipTrunk::setUseDevicePoolCdpnTransformCss()
     * @uses LSipTrunk::setUnattendedPort()
     * @uses LSipTrunk::setTransmitUtf8()
     * @uses LSipTrunk::setSubscribeCallingSearchSpaceName()
     * @uses LSipTrunk::setRerouteCallingSearchSpaceName()
     * @uses LSipTrunk::setReferCallingSearchSpaceName()
     * @uses LSipTrunk::setMtpRequired()
     * @uses LSipTrunk::setPresenceGroupName()
     * @uses LSipTrunk::setUnknownPrefix()
     * @uses LSipTrunk::setDestAddrIsSrv()
     * @uses LSipTrunk::setTkSipCodec()
     * @uses LSipTrunk::setSigDigits()
     * @uses LSipTrunk::setConnectedNamePresentation()
     * @uses LSipTrunk::setConnectedPartyIdPresentation()
     * @uses LSipTrunk::setCallingPartySelection()
     * @uses LSipTrunk::setCallingname()
     * @uses LSipTrunk::setCallingLineIdPresentation()
     * @uses LSipTrunk::setPrefixDn()
     * @uses LSipTrunk::setCallerName()
     * @uses LSipTrunk::setCallerIdDn()
     * @uses LSipTrunk::setAcceptInboundRdnis()
     * @uses LSipTrunk::setAcceptOutboundRdnis()
     * @uses LSipTrunk::setSrtpAllowed()
     * @uses LSipTrunk::setSrtpFallbackAllowed()
     * @uses LSipTrunk::setIsPaiEnabled()
     * @uses LSipTrunk::setSipPrivacy()
     * @uses LSipTrunk::setIsRpidEnabled()
     * @uses LSipTrunk::setSipAssertedType()
     * @uses LSipTrunk::setDtmfSignalingMethod()
     * @uses LSipTrunk::setRouteClassSignalling()
     * @uses LSipTrunk::setSipTrunkType()
     * @uses LSipTrunk::setPstnAccess()
     * @uses LSipTrunk::setImeE164TransformationName()
     * @uses LSipTrunk::setUseImePublicIpPort()
     * @uses LSipTrunk::setUseDevicePoolCntdPnTransformationCss()
     * @uses LSipTrunk::setUseDevicePoolCgpnTransformCssUnkn()
     * @uses LSipTrunk::setSipNormalizationScriptName()
     * @uses LSipTrunk::setRunOnEveryNode()
     * @uses LSipTrunk::setUnknownStripDigits()
     * @uses LSipTrunk::setCgpnTransformationUnknownCssName()
     * @uses LSipTrunk::setTunneledProtocol()
     * @uses LSipTrunk::setAsn1RoseOidEncoding()
     * @uses LSipTrunk::setQsigVariant()
     * @uses LSipTrunk::setPathReplacementSupport()
     * @uses LSipTrunk::setEnableQsigUtf8()
     * @uses LSipTrunk::setScriptParameters()
     * @uses LSipTrunk::setScriptTraceEnabled()
     * @uses LSipTrunk::setTrunkTrafficSecure()
     * @uses LSipTrunk::setCallingAndCalledPartyInfoFormat()
     * @uses LSipTrunk::setUseCallerIdCallerNameinUriOutgoingRequest()
     * @uses LSipTrunk::setRequestUriDomainName()
     * @uses LSipTrunk::setEnableCiscoRecordingQsigTunneling()
     * @uses LSipTrunk::setCalledPartyUnknownTransformationCssName()
     * @uses LSipTrunk::setCalledPartyUnknownPrefix()
     * @uses LSipTrunk::setCalledPartyUnknownStripDigits()
     * @uses LSipTrunk::setUseDevicePoolCalledCssUnkn()
     * @uses LSipTrunk::setConfidentialAccess()
     * @uses LSipTrunk::setCtiid()
     * @uses LSipTrunk::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @param string $traceFlag
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfileName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @param string $sendGeoLocation
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param string $unattendedPort
     * @param string $transmitUtf8
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $referCallingSearchSpaceName
     * @param string $mtpRequired
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @param string $unknownPrefix
     * @param string $destAddrIsSrv
     * @param string $tkSipCodec
     * @param \Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @param string $connectedNamePresentation
     * @param string $connectedPartyIdPresentation
     * @param string $callingPartySelection
     * @param string $callingname
     * @param string $callingLineIdPresentation
     * @param string $prefixDn
     * @param string $callerName
     * @param string $callerIdDn
     * @param string $acceptInboundRdnis
     * @param string $acceptOutboundRdnis
     * @param string $srtpAllowed
     * @param string $srtpFallbackAllowed
     * @param string $isPaiEnabled
     * @param string $sipPrivacy
     * @param string $isRpidEnabled
     * @param string $sipAssertedType
     * @param string $dtmfSignalingMethod
     * @param string $routeClassSignalling
     * @param string $sipTrunkType
     * @param string $pstnAccess
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     * @param string $useImePublicIpPort
     * @param string $useDevicePoolCntdPnTransformationCss
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipNormalizationScriptName
     * @param string $runOnEveryNode
     * @param int $unknownStripDigits
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationUnknownCssName
     * @param string $tunneledProtocol
     * @param string $asn1RoseOidEncoding
     * @param string $qsigVariant
     * @param string $pathReplacementSupport
     * @param string $enableQsigUtf8
     * @param string $scriptParameters
     * @param string $scriptTraceEnabled
     * @param string $trunkTrafficSecure
     * @param string $callingAndCalledPartyInfoFormat
     * @param string $useCallerIdCallerNameinUriOutgoingRequest
     * @param string $requestUriDomainName
     * @param string $enableCiscoRecordingQsigTunneling
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName
     * @param string $calledPartyUnknownPrefix
     * @param string $calledPartyUnknownStripDigits
     * @param string $useDevicePoolCalledCssUnkn
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, $networkLocation = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, $packetCaptureMode = null, $packetCaptureDuration = null, \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null, $traceFlag = null, $mlppIndicationStatus = null, $preemption = null, $useTrustedRelayPoint = null, $retryVideoCallAsAudio = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfileName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null, $sendGeoLocation = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = null, $unattendedPort = null, $transmitUtf8 = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $referCallingSearchSpaceName = null, $mtpRequired = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null, $unknownPrefix = null, $destAddrIsSrv = null, $tkSipCodec = null, \Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = null, $connectedNamePresentation = null, $connectedPartyIdPresentation = null, $callingPartySelection = null, $callingname = null, $callingLineIdPresentation = null, $prefixDn = null, $callerName = null, $callerIdDn = null, $acceptInboundRdnis = null, $acceptOutboundRdnis = null, $srtpAllowed = null, $srtpFallbackAllowed = null, $isPaiEnabled = null, $sipPrivacy = null, $isRpidEnabled = null, $sipAssertedType = null, $dtmfSignalingMethod = null, $routeClassSignalling = null, $sipTrunkType = null, $pstnAccess = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null, $useImePublicIpPort = null, $useDevicePoolCntdPnTransformationCss = null, $useDevicePoolCgpnTransformCssUnkn = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipNormalizationScriptName = null, $runOnEveryNode = null, $unknownStripDigits = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationUnknownCssName = null, $tunneledProtocol = null, $asn1RoseOidEncoding = null, $qsigVariant = null, $pathReplacementSupport = null, $enableQsigUtf8 = null, $scriptParameters = null, $scriptTraceEnabled = null, $trunkTrafficSecure = null, $callingAndCalledPartyInfoFormat = null, $useCallerIdCallerNameinUriOutgoingRequest = null, $requestUriDomainName = null, $enableCiscoRecordingQsigTunneling = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName = null, $calledPartyUnknownPrefix = null, $calledPartyUnknownStripDigits = null, $useDevicePoolCalledCssUnkn = null, \Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setLoadInformation($loadInformation)
            ->setTraceFlag($traceFlag)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setSecurityProfileName($securityProfileName)
            ->setSipProfileName($sipProfileName)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setSendGeoLocation($sendGeoLocation)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setUnattendedPort($unattendedPort)
            ->setTransmitUtf8($transmitUtf8)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setRerouteCallingSearchSpaceName($rerouteCallingSearchSpaceName)
            ->setReferCallingSearchSpaceName($referCallingSearchSpaceName)
            ->setMtpRequired($mtpRequired)
            ->setPresenceGroupName($presenceGroupName)
            ->setUnknownPrefix($unknownPrefix)
            ->setDestAddrIsSrv($destAddrIsSrv)
            ->setTkSipCodec($tkSipCodec)
            ->setSigDigits($sigDigits)
            ->setConnectedNamePresentation($connectedNamePresentation)
            ->setConnectedPartyIdPresentation($connectedPartyIdPresentation)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingname($callingname)
            ->setCallingLineIdPresentation($callingLineIdPresentation)
            ->setPrefixDn($prefixDn)
            ->setCallerName($callerName)
            ->setCallerIdDn($callerIdDn)
            ->setAcceptInboundRdnis($acceptInboundRdnis)
            ->setAcceptOutboundRdnis($acceptOutboundRdnis)
            ->setSrtpAllowed($srtpAllowed)
            ->setSrtpFallbackAllowed($srtpFallbackAllowed)
            ->setIsPaiEnabled($isPaiEnabled)
            ->setSipPrivacy($sipPrivacy)
            ->setIsRpidEnabled($isRpidEnabled)
            ->setSipAssertedType($sipAssertedType)
            ->setDtmfSignalingMethod($dtmfSignalingMethod)
            ->setRouteClassSignalling($routeClassSignalling)
            ->setSipTrunkType($sipTrunkType)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setUseImePublicIpPort($useImePublicIpPort)
            ->setUseDevicePoolCntdPnTransformationCss($useDevicePoolCntdPnTransformationCss)
            ->setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn)
            ->setSipNormalizationScriptName($sipNormalizationScriptName)
            ->setRunOnEveryNode($runOnEveryNode)
            ->setUnknownStripDigits($unknownStripDigits)
            ->setCgpnTransformationUnknownCssName($cgpnTransformationUnknownCssName)
            ->setTunneledProtocol($tunneledProtocol)
            ->setAsn1RoseOidEncoding($asn1RoseOidEncoding)
            ->setQsigVariant($qsigVariant)
            ->setPathReplacementSupport($pathReplacementSupport)
            ->setEnableQsigUtf8($enableQsigUtf8)
            ->setScriptParameters($scriptParameters)
            ->setScriptTraceEnabled($scriptTraceEnabled)
            ->setTrunkTrafficSecure($trunkTrafficSecure)
            ->setCallingAndCalledPartyInfoFormat($callingAndCalledPartyInfoFormat)
            ->setUseCallerIdCallerNameinUriOutgoingRequest($useCallerIdCallerNameinUriOutgoingRequest)
            ->setRequestUriDomainName($requestUriDomainName)
            ->setEnableCiscoRecordingQsigTunneling($enableCiscoRecordingQsigTunneling)
            ->setCalledPartyUnknownTransformationCssName($calledPartyUnknownTransformationCssName)
            ->setCalledPartyUnknownPrefix($calledPartyUnknownPrefix)
            ->setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits)
            ->setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn)
            ->setConfidentialAccess($confidentialAccess)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($name) && mb_strlen($name) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XProduct', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XModel::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XModel', is_array($model) ? implode(', ', $model) : var_export($model, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XClass::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XClass', is_array($class) ? implode(', ', $class) : var_export($class, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol', is_array($protocol) ? implode(', ', $protocol) : var_export($protocol, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setProtocolSide($protocolSide = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide', is_array($protocolSide) ? implode(', ', $protocolSide) : var_export($protocolSide, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setDevicePoolName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setCommonDeviceConfigName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setNetworkLocation($networkLocation = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation', is_array($networkLocation) ? implode(', ', $networkLocation) : var_export($networkLocation, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setLocationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setMediaResourceListName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSourceId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid($networkHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId', is_array($networkHoldMohAudioSourceId) ? implode(', ', $networkHoldMohAudioSourceId) : var_export($networkHoldMohAudioSourceId, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId', is_array($userHoldMohAudioSourceId) ? implode(', ', $userHoldMohAudioSourceId) : var_export($userHoldMohAudioSourceId, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setAutomatedAlternateRoutingCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setAarNeighborhoodName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPacketCaptureMode::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setPacketCaptureMode($packetCaptureMode = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPacketCaptureMode', is_array($packetCaptureMode) ? implode(', ', $packetCaptureMode) : var_export($packetCaptureMode, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return $this->packetCaptureDuration;
    }
    /**
     * Set packetCaptureDuration value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setPacketCaptureDuration($packetCaptureDuration = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($packetCaptureDuration) ? implode(', ', $packetCaptureDuration) : var_export($packetCaptureDuration, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->packetCaptureDuration = $packetCaptureDuration;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setLoadInformation(\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traceFlag, true), gettype($traceFlag)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($traceFlag, true)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($mlppIndicationStatus) ? implode(', ', $mlppIndicationStatus) : var_export($mlppIndicationStatus, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setPreemption($preemption = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption', is_array($preemption) ? implode(', ', $preemption) : var_export($preemption, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($useTrustedRelayPoint) ? implode(', ', $useTrustedRelayPoint) : var_export($useTrustedRelayPoint, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = null)
    {
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retryVideoCallAsAudio, true), gettype($retryVideoCallAsAudio)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setSecurityProfileName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get sipProfileName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSipProfileName()
    {
        return $this->sipProfileName;
    }
    /**
     * Set sipProfileName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfileName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setSipProfileName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfileName = null)
    {
        $this->sipProfileName = $sipProfileName;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setCgpnTransformationCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCgpnTransformCss, true), gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setGeoLocationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setGeoLocationFilterName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get sendGeoLocation value
     * @return string|null
     */
    public function getSendGeoLocation()
    {
        return $this->sendGeoLocation;
    }
    /**
     * Set sendGeoLocation value
     * @param string $sendGeoLocation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setSendGeoLocation($sendGeoLocation = null)
    {
        // validation for constraint: string
        if (!is_null($sendGeoLocation) && !is_string($sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendGeoLocation, true), gettype($sendGeoLocation)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($sendGeoLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($sendGeoLocation, true)), __LINE__);
        }
        $this->sendGeoLocation = $sendGeoLocation;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return $this->cdpnTransformationCssName;
    }
    /**
     * Set cdpnTransformationCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setCdpnTransformationCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null)
    {
        $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = null)
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCdpnTransformCss) && !is_string($useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCdpnTransformCss, true), gettype($useDevicePoolCdpnTransformCss)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCdpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCdpnTransformCss, true)), __LINE__);
        }
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unattendedPort, true), gettype($unattendedPort)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($unattendedPort, true)), __LINE__);
        }
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setTransmitUtf8($transmitUtf8 = null)
    {
        // validation for constraint: string
        if (!is_null($transmitUtf8) && !is_string($transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transmitUtf8, true), gettype($transmitUtf8)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($transmitUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($transmitUtf8, true)), __LINE__);
        }
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setSubscribeCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get rerouteCallingSearchSpaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRerouteCallingSearchSpaceName()
    {
        return $this->rerouteCallingSearchSpaceName;
    }
    /**
     * Set rerouteCallingSearchSpaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setRerouteCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName = null)
    {
        $this->rerouteCallingSearchSpaceName = $rerouteCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get referCallingSearchSpaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getReferCallingSearchSpaceName()
    {
        return $this->referCallingSearchSpaceName;
    }
    /**
     * Set referCallingSearchSpaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $referCallingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setReferCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $referCallingSearchSpaceName = null)
    {
        $this->referCallingSearchSpaceName = $referCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get mtpRequired value
     * @return string|null
     */
    public function getMtpRequired()
    {
        return $this->mtpRequired;
    }
    /**
     * Set mtpRequired value
     * @param string $mtpRequired
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setMtpRequired($mtpRequired = null)
    {
        // validation for constraint: string
        if (!is_null($mtpRequired) && !is_string($mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mtpRequired, true), gettype($mtpRequired)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($mtpRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($mtpRequired, true)), __LINE__);
        }
        $this->mtpRequired = $mtpRequired;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setPresenceGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get unknownPrefix value
     * @return string|null
     */
    public function getUnknownPrefix()
    {
        return $this->unknownPrefix;
    }
    /**
     * Set unknownPrefix value
     * @param string $unknownPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setUnknownPrefix($unknownPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($unknownPrefix) && !is_string($unknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unknownPrefix, true), gettype($unknownPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($unknownPrefix) && mb_strlen($unknownPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($unknownPrefix)), __LINE__);
        }
        $this->unknownPrefix = $unknownPrefix;
        return $this;
    }
    /**
     * Get destAddrIsSrv value
     * @return string|null
     */
    public function getDestAddrIsSrv()
    {
        return $this->destAddrIsSrv;
    }
    /**
     * Set destAddrIsSrv value
     * @param string $destAddrIsSrv
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setDestAddrIsSrv($destAddrIsSrv = null)
    {
        // validation for constraint: string
        if (!is_null($destAddrIsSrv) && !is_string($destAddrIsSrv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destAddrIsSrv, true), gettype($destAddrIsSrv)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($destAddrIsSrv) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $destAddrIsSrv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($destAddrIsSrv, true)), __LINE__);
        }
        $this->destAddrIsSrv = $destAddrIsSrv;
        return $this;
    }
    /**
     * Get tkSipCodec value
     * @return string|null
     */
    public function getTkSipCodec()
    {
        return $this->tkSipCodec;
    }
    /**
     * Set tkSipCodec value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XSIPCodec::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XSIPCodec::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tkSipCodec
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setTkSipCodec($tkSipCodec = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XSIPCodec::valueIsValid($tkSipCodec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XSIPCodec', is_array($tkSipCodec) ? implode(', ', $tkSipCodec) : var_export($tkSipCodec, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XSIPCodec::getValidValues())), __LINE__);
        }
        $this->tkSipCodec = $tkSipCodec;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\SigDigits|null
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setSigDigits(\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = null)
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get connectedNamePresentation value
     * @return string|null
     */
    public function getConnectedNamePresentation()
    {
        return $this->connectedNamePresentation;
    }
    /**
     * Set connectedNamePresentation value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedNamePresentation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setConnectedNamePresentation($connectedNamePresentation = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($connectedNamePresentation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($connectedNamePresentation) ? implode(', ', $connectedNamePresentation) : var_export($connectedNamePresentation, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedNamePresentation = $connectedNamePresentation;
        return $this;
    }
    /**
     * Get connectedPartyIdPresentation value
     * @return string|null
     */
    public function getConnectedPartyIdPresentation()
    {
        return $this->connectedPartyIdPresentation;
    }
    /**
     * Set connectedPartyIdPresentation value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedPartyIdPresentation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setConnectedPartyIdPresentation($connectedPartyIdPresentation = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($connectedPartyIdPresentation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($connectedPartyIdPresentation) ? implode(', ', $connectedPartyIdPresentation) : var_export($connectedPartyIdPresentation, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedPartyIdPresentation = $connectedPartyIdPresentation;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySelection
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setCallingPartySelection($callingPartySelection = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection::valueIsValid($callingPartySelection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection', is_array($callingPartySelection) ? implode(', ', $callingPartySelection) : var_export($callingPartySelection, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection::getValidValues())), __LINE__);
        }
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingname value
     * @return string|null
     */
    public function getCallingname()
    {
        return $this->callingname;
    }
    /**
     * Set callingname value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingname
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setCallingname($callingname = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($callingname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($callingname) ? implode(', ', $callingname) : var_export($callingname, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingname = $callingname;
        return $this;
    }
    /**
     * Get callingLineIdPresentation value
     * @return string|null
     */
    public function getCallingLineIdPresentation()
    {
        return $this->callingLineIdPresentation;
    }
    /**
     * Set callingLineIdPresentation value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLineIdPresentation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setCallingLineIdPresentation($callingLineIdPresentation = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($callingLineIdPresentation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($callingLineIdPresentation) ? implode(', ', $callingLineIdPresentation) : var_export($callingLineIdPresentation, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingLineIdPresentation = $callingLineIdPresentation;
        return $this;
    }
    /**
     * Get prefixDn value
     * @return string|null
     */
    public function getPrefixDn()
    {
        return $this->prefixDn;
    }
    /**
     * Set prefixDn value
     * @param string $prefixDn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setPrefixDn($prefixDn = null)
    {
        // validation for constraint: string
        if (!is_null($prefixDn) && !is_string($prefixDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefixDn, true), gettype($prefixDn)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($prefixDn) && mb_strlen($prefixDn) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($prefixDn)), __LINE__);
        }
        $this->prefixDn = $prefixDn;
        return $this;
    }
    /**
     * Get callerName value
     * @return string|null
     */
    public function getCallerName()
    {
        return $this->callerName;
    }
    /**
     * Set callerName value
     * @param string $callerName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setCallerName($callerName = null)
    {
        // validation for constraint: string
        if (!is_null($callerName) && !is_string($callerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callerName, true), gettype($callerName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callerName) && mb_strlen($callerName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callerName)), __LINE__);
        }
        $this->callerName = $callerName;
        return $this;
    }
    /**
     * Get callerIdDn value
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return $this->callerIdDn;
    }
    /**
     * Set callerIdDn value
     * @param string $callerIdDn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callerIdDn, true), gettype($callerIdDn)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callerIdDn) && mb_strlen($callerIdDn) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callerIdDn)), __LINE__);
        }
        $this->callerIdDn = $callerIdDn;
        return $this;
    }
    /**
     * Get acceptInboundRdnis value
     * @return string|null
     */
    public function getAcceptInboundRdnis()
    {
        return $this->acceptInboundRdnis;
    }
    /**
     * Set acceptInboundRdnis value
     * @param string $acceptInboundRdnis
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setAcceptInboundRdnis($acceptInboundRdnis = null)
    {
        // validation for constraint: string
        if (!is_null($acceptInboundRdnis) && !is_string($acceptInboundRdnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptInboundRdnis, true), gettype($acceptInboundRdnis)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($acceptInboundRdnis) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptInboundRdnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($acceptInboundRdnis, true)), __LINE__);
        }
        $this->acceptInboundRdnis = $acceptInboundRdnis;
        return $this;
    }
    /**
     * Get acceptOutboundRdnis value
     * @return string|null
     */
    public function getAcceptOutboundRdnis()
    {
        return $this->acceptOutboundRdnis;
    }
    /**
     * Set acceptOutboundRdnis value
     * @param string $acceptOutboundRdnis
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setAcceptOutboundRdnis($acceptOutboundRdnis = null)
    {
        // validation for constraint: string
        if (!is_null($acceptOutboundRdnis) && !is_string($acceptOutboundRdnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptOutboundRdnis, true), gettype($acceptOutboundRdnis)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($acceptOutboundRdnis) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptOutboundRdnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($acceptOutboundRdnis, true)), __LINE__);
        }
        $this->acceptOutboundRdnis = $acceptOutboundRdnis;
        return $this;
    }
    /**
     * Get srtpAllowed value
     * @return string|null
     */
    public function getSrtpAllowed()
    {
        return $this->srtpAllowed;
    }
    /**
     * Set srtpAllowed value
     * @param string $srtpAllowed
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setSrtpAllowed($srtpAllowed = null)
    {
        // validation for constraint: string
        if (!is_null($srtpAllowed) && !is_string($srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($srtpAllowed, true), gettype($srtpAllowed)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($srtpAllowed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($srtpAllowed, true)), __LINE__);
        }
        $this->srtpAllowed = $srtpAllowed;
        return $this;
    }
    /**
     * Get srtpFallbackAllowed value
     * @return string|null
     */
    public function getSrtpFallbackAllowed()
    {
        return $this->srtpFallbackAllowed;
    }
    /**
     * Set srtpFallbackAllowed value
     * @param string $srtpFallbackAllowed
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setSrtpFallbackAllowed($srtpFallbackAllowed = null)
    {
        // validation for constraint: string
        if (!is_null($srtpFallbackAllowed) && !is_string($srtpFallbackAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($srtpFallbackAllowed, true), gettype($srtpFallbackAllowed)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($srtpFallbackAllowed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $srtpFallbackAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($srtpFallbackAllowed, true)), __LINE__);
        }
        $this->srtpFallbackAllowed = $srtpFallbackAllowed;
        return $this;
    }
    /**
     * Get isPaiEnabled value
     * @return string|null
     */
    public function getIsPaiEnabled()
    {
        return $this->isPaiEnabled;
    }
    /**
     * Set isPaiEnabled value
     * @param string $isPaiEnabled
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setIsPaiEnabled($isPaiEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($isPaiEnabled) && !is_string($isPaiEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isPaiEnabled, true), gettype($isPaiEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isPaiEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPaiEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isPaiEnabled, true)), __LINE__);
        }
        $this->isPaiEnabled = $isPaiEnabled;
        return $this;
    }
    /**
     * Get sipPrivacy value
     * @return string|null
     */
    public function getSipPrivacy()
    {
        return $this->sipPrivacy;
    }
    /**
     * Set sipPrivacy value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XSipPrivacy::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XSipPrivacy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipPrivacy
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setSipPrivacy($sipPrivacy = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XSipPrivacy::valueIsValid($sipPrivacy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XSipPrivacy', is_array($sipPrivacy) ? implode(', ', $sipPrivacy) : var_export($sipPrivacy, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XSipPrivacy::getValidValues())), __LINE__);
        }
        $this->sipPrivacy = $sipPrivacy;
        return $this;
    }
    /**
     * Get isRpidEnabled value
     * @return string|null
     */
    public function getIsRpidEnabled()
    {
        return $this->isRpidEnabled;
    }
    /**
     * Set isRpidEnabled value
     * @param string $isRpidEnabled
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setIsRpidEnabled($isRpidEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($isRpidEnabled) && !is_string($isRpidEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isRpidEnabled, true), gettype($isRpidEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isRpidEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isRpidEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isRpidEnabled, true)), __LINE__);
        }
        $this->isRpidEnabled = $isRpidEnabled;
        return $this;
    }
    /**
     * Get sipAssertedType value
     * @return string|null
     */
    public function getSipAssertedType()
    {
        return $this->sipAssertedType;
    }
    /**
     * Set sipAssertedType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XSipAssertedType::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XSipAssertedType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipAssertedType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setSipAssertedType($sipAssertedType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XSipAssertedType::valueIsValid($sipAssertedType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XSipAssertedType', is_array($sipAssertedType) ? implode(', ', $sipAssertedType) : var_export($sipAssertedType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XSipAssertedType::getValidValues())), __LINE__);
        }
        $this->sipAssertedType = $sipAssertedType;
        return $this;
    }
    /**
     * Get dtmfSignalingMethod value
     * @return string|null
     */
    public function getDtmfSignalingMethod()
    {
        return $this->dtmfSignalingMethod;
    }
    /**
     * Set dtmfSignalingMethod value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDTMFSignaling::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDTMFSignaling::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfSignalingMethod
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setDtmfSignalingMethod($dtmfSignalingMethod = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDTMFSignaling::valueIsValid($dtmfSignalingMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDTMFSignaling', is_array($dtmfSignalingMethod) ? implode(', ', $dtmfSignalingMethod) : var_export($dtmfSignalingMethod, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDTMFSignaling::getValidValues())), __LINE__);
        }
        $this->dtmfSignalingMethod = $dtmfSignalingMethod;
        return $this;
    }
    /**
     * Get routeClassSignalling value
     * @return string|null
     */
    public function getRouteClassSignalling()
    {
        return $this->routeClassSignalling;
    }
    /**
     * Set routeClassSignalling value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routeClassSignalling
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setRouteClassSignalling($routeClassSignalling = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($routeClassSignalling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($routeClassSignalling) ? implode(', ', $routeClassSignalling) : var_export($routeClassSignalling, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->routeClassSignalling = $routeClassSignalling;
        return $this;
    }
    /**
     * Get sipTrunkType value
     * @return string|null
     */
    public function getSipTrunkType()
    {
        return $this->sipTrunkType;
    }
    /**
     * Set sipTrunkType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkService::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipTrunkType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setSipTrunkType($sipTrunkType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTrunkService::valueIsValid($sipTrunkType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkService', is_array($sipTrunkType) ? implode(', ', $sipTrunkType) : var_export($sipTrunkType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTrunkService::getValidValues())), __LINE__);
        }
        $this->sipTrunkType = $sipTrunkType;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setPstnAccess($pstnAccess = null)
    {
        // validation for constraint: string
        if (!is_null($pstnAccess) && !is_string($pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pstnAccess, true), gettype($pstnAccess)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($pstnAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($pstnAccess, true)), __LINE__);
        }
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return $this->imeE164TransformationName;
    }
    /**
     * Set imeE164TransformationName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setImeE164TransformationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null)
    {
        $this->imeE164TransformationName = $imeE164TransformationName;
        return $this;
    }
    /**
     * Get useImePublicIpPort value
     * @return string|null
     */
    public function getUseImePublicIpPort()
    {
        return $this->useImePublicIpPort;
    }
    /**
     * Set useImePublicIpPort value
     * @param string $useImePublicIpPort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setUseImePublicIpPort($useImePublicIpPort = null)
    {
        // validation for constraint: string
        if (!is_null($useImePublicIpPort) && !is_string($useImePublicIpPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useImePublicIpPort, true), gettype($useImePublicIpPort)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useImePublicIpPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useImePublicIpPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useImePublicIpPort, true)), __LINE__);
        }
        $this->useImePublicIpPort = $useImePublicIpPort;
        return $this;
    }
    /**
     * Get useDevicePoolCntdPnTransformationCss value
     * @return string|null
     */
    public function getUseDevicePoolCntdPnTransformationCss()
    {
        return $this->useDevicePoolCntdPnTransformationCss;
    }
    /**
     * Set useDevicePoolCntdPnTransformationCss value
     * @param string $useDevicePoolCntdPnTransformationCss
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setUseDevicePoolCntdPnTransformationCss($useDevicePoolCntdPnTransformationCss = null)
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCntdPnTransformationCss) && !is_string($useDevicePoolCntdPnTransformationCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCntdPnTransformationCss, true), gettype($useDevicePoolCntdPnTransformationCss)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCntdPnTransformationCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCntdPnTransformationCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCntdPnTransformationCss, true)), __LINE__);
        }
        $this->useDevicePoolCntdPnTransformationCss = $useDevicePoolCntdPnTransformationCss;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnkn()
    {
        return $this->useDevicePoolCgpnTransformCssUnkn;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnkn value
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn = null)
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssUnkn) && !is_string($useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCgpnTransformCssUnkn, true), gettype($useDevicePoolCgpnTransformCssUnkn)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCgpnTransformCssUnkn) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCgpnTransformCssUnkn, true)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssUnkn = $useDevicePoolCgpnTransformCssUnkn;
        return $this;
    }
    /**
     * Get sipNormalizationScriptName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSipNormalizationScriptName()
    {
        return $this->sipNormalizationScriptName;
    }
    /**
     * Set sipNormalizationScriptName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipNormalizationScriptName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setSipNormalizationScriptName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipNormalizationScriptName = null)
    {
        $this->sipNormalizationScriptName = $sipNormalizationScriptName;
        return $this;
    }
    /**
     * Get runOnEveryNode value
     * @return string|null
     */
    public function getRunOnEveryNode()
    {
        return $this->runOnEveryNode;
    }
    /**
     * Set runOnEveryNode value
     * @param string $runOnEveryNode
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setRunOnEveryNode($runOnEveryNode = null)
    {
        // validation for constraint: string
        if (!is_null($runOnEveryNode) && !is_string($runOnEveryNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($runOnEveryNode, true), gettype($runOnEveryNode)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($runOnEveryNode) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $runOnEveryNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($runOnEveryNode, true)), __LINE__);
        }
        $this->runOnEveryNode = $runOnEveryNode;
        return $this;
    }
    /**
     * Get unknownStripDigits value
     * @return int|null
     */
    public function getUnknownStripDigits()
    {
        return $this->unknownStripDigits;
    }
    /**
     * Set unknownStripDigits value
     * @param int $unknownStripDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setUnknownStripDigits($unknownStripDigits = null)
    {
        // validation for constraint: int
        if (!is_null($unknownStripDigits) && !(is_int($unknownStripDigits) || ctype_digit($unknownStripDigits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unknownStripDigits, true), gettype($unknownStripDigits)), __LINE__);
        }
        $this->unknownStripDigits = $unknownStripDigits;
        return $this;
    }
    /**
     * Get cgpnTransformationUnknownCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationUnknownCssName()
    {
        return $this->cgpnTransformationUnknownCssName;
    }
    /**
     * Set cgpnTransformationUnknownCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationUnknownCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setCgpnTransformationUnknownCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationUnknownCssName = null)
    {
        $this->cgpnTransformationUnknownCssName = $cgpnTransformationUnknownCssName;
        return $this;
    }
    /**
     * Get tunneledProtocol value
     * @return string|null
     */
    public function getTunneledProtocol()
    {
        return $this->tunneledProtocol;
    }
    /**
     * Set tunneledProtocol value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTunneledProtocol::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTunneledProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tunneledProtocol
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setTunneledProtocol($tunneledProtocol = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTunneledProtocol::valueIsValid($tunneledProtocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTunneledProtocol', is_array($tunneledProtocol) ? implode(', ', $tunneledProtocol) : var_export($tunneledProtocol, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTunneledProtocol::getValidValues())), __LINE__);
        }
        $this->tunneledProtocol = $tunneledProtocol;
        return $this;
    }
    /**
     * Get asn1RoseOidEncoding value
     * @return string|null
     */
    public function getAsn1RoseOidEncoding()
    {
        return $this->asn1RoseOidEncoding;
    }
    /**
     * Set asn1RoseOidEncoding value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XASN1RoseOidEncoding::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XASN1RoseOidEncoding::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $asn1RoseOidEncoding
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setAsn1RoseOidEncoding($asn1RoseOidEncoding = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XASN1RoseOidEncoding::valueIsValid($asn1RoseOidEncoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XASN1RoseOidEncoding', is_array($asn1RoseOidEncoding) ? implode(', ', $asn1RoseOidEncoding) : var_export($asn1RoseOidEncoding, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XASN1RoseOidEncoding::getValidValues())), __LINE__);
        }
        $this->asn1RoseOidEncoding = $asn1RoseOidEncoding;
        return $this;
    }
    /**
     * Get qsigVariant value
     * @return string|null
     */
    public function getQsigVariant()
    {
        return $this->qsigVariant;
    }
    /**
     * Set qsigVariant value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XQSIGVariant::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XQSIGVariant::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qsigVariant
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setQsigVariant($qsigVariant = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XQSIGVariant::valueIsValid($qsigVariant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XQSIGVariant', is_array($qsigVariant) ? implode(', ', $qsigVariant) : var_export($qsigVariant, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XQSIGVariant::getValidValues())), __LINE__);
        }
        $this->qsigVariant = $qsigVariant;
        return $this;
    }
    /**
     * Get pathReplacementSupport value
     * @return string|null
     */
    public function getPathReplacementSupport()
    {
        return $this->pathReplacementSupport;
    }
    /**
     * Set pathReplacementSupport value
     * @param string $pathReplacementSupport
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setPathReplacementSupport($pathReplacementSupport = null)
    {
        // validation for constraint: string
        if (!is_null($pathReplacementSupport) && !is_string($pathReplacementSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pathReplacementSupport, true), gettype($pathReplacementSupport)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($pathReplacementSupport) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pathReplacementSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($pathReplacementSupport, true)), __LINE__);
        }
        $this->pathReplacementSupport = $pathReplacementSupport;
        return $this;
    }
    /**
     * Get enableQsigUtf8 value
     * @return string|null
     */
    public function getEnableQsigUtf8()
    {
        return $this->enableQsigUtf8;
    }
    /**
     * Set enableQsigUtf8 value
     * @param string $enableQsigUtf8
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setEnableQsigUtf8($enableQsigUtf8 = null)
    {
        // validation for constraint: string
        if (!is_null($enableQsigUtf8) && !is_string($enableQsigUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableQsigUtf8, true), gettype($enableQsigUtf8)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableQsigUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableQsigUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableQsigUtf8, true)), __LINE__);
        }
        $this->enableQsigUtf8 = $enableQsigUtf8;
        return $this;
    }
    /**
     * Get scriptParameters value
     * @return string|null
     */
    public function getScriptParameters()
    {
        return $this->scriptParameters;
    }
    /**
     * Set scriptParameters value
     * @param string $scriptParameters
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setScriptParameters($scriptParameters = null)
    {
        // validation for constraint: string
        if (!is_null($scriptParameters) && !is_string($scriptParameters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scriptParameters, true), gettype($scriptParameters)), __LINE__);
        }
        $this->scriptParameters = $scriptParameters;
        return $this;
    }
    /**
     * Get scriptTraceEnabled value
     * @return string|null
     */
    public function getScriptTraceEnabled()
    {
        return $this->scriptTraceEnabled;
    }
    /**
     * Set scriptTraceEnabled value
     * @param string $scriptTraceEnabled
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setScriptTraceEnabled($scriptTraceEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($scriptTraceEnabled) && !is_string($scriptTraceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scriptTraceEnabled, true), gettype($scriptTraceEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($scriptTraceEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $scriptTraceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($scriptTraceEnabled, true)), __LINE__);
        }
        $this->scriptTraceEnabled = $scriptTraceEnabled;
        return $this;
    }
    /**
     * Get trunkTrafficSecure value
     * @return string|null
     */
    public function getTrunkTrafficSecure()
    {
        return $this->trunkTrafficSecure;
    }
    /**
     * Set trunkTrafficSecure value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XSIPTrunkCallLegSecurity::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XSIPTrunkCallLegSecurity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkTrafficSecure
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setTrunkTrafficSecure($trunkTrafficSecure = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XSIPTrunkCallLegSecurity::valueIsValid($trunkTrafficSecure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XSIPTrunkCallLegSecurity', is_array($trunkTrafficSecure) ? implode(', ', $trunkTrafficSecure) : var_export($trunkTrafficSecure, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XSIPTrunkCallLegSecurity::getValidValues())), __LINE__);
        }
        $this->trunkTrafficSecure = $trunkTrafficSecure;
        return $this;
    }
    /**
     * Get callingAndCalledPartyInfoFormat value
     * @return string|null
     */
    public function getCallingAndCalledPartyInfoFormat()
    {
        return $this->callingAndCalledPartyInfoFormat;
    }
    /**
     * Set callingAndCalledPartyInfoFormat value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XSIPIdentityBlend::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XSIPIdentityBlend::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingAndCalledPartyInfoFormat
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setCallingAndCalledPartyInfoFormat($callingAndCalledPartyInfoFormat = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XSIPIdentityBlend::valueIsValid($callingAndCalledPartyInfoFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XSIPIdentityBlend', is_array($callingAndCalledPartyInfoFormat) ? implode(', ', $callingAndCalledPartyInfoFormat) : var_export($callingAndCalledPartyInfoFormat, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XSIPIdentityBlend::getValidValues())), __LINE__);
        }
        $this->callingAndCalledPartyInfoFormat = $callingAndCalledPartyInfoFormat;
        return $this;
    }
    /**
     * Get useCallerIdCallerNameinUriOutgoingRequest value
     * @return string|null
     */
    public function getUseCallerIdCallerNameinUriOutgoingRequest()
    {
        return $this->useCallerIdCallerNameinUriOutgoingRequest;
    }
    /**
     * Set useCallerIdCallerNameinUriOutgoingRequest value
     * @param string $useCallerIdCallerNameinUriOutgoingRequest
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setUseCallerIdCallerNameinUriOutgoingRequest($useCallerIdCallerNameinUriOutgoingRequest = null)
    {
        // validation for constraint: string
        if (!is_null($useCallerIdCallerNameinUriOutgoingRequest) && !is_string($useCallerIdCallerNameinUriOutgoingRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useCallerIdCallerNameinUriOutgoingRequest, true), gettype($useCallerIdCallerNameinUriOutgoingRequest)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useCallerIdCallerNameinUriOutgoingRequest) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useCallerIdCallerNameinUriOutgoingRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useCallerIdCallerNameinUriOutgoingRequest, true)), __LINE__);
        }
        $this->useCallerIdCallerNameinUriOutgoingRequest = $useCallerIdCallerNameinUriOutgoingRequest;
        return $this;
    }
    /**
     * Get requestUriDomainName value
     * @return string|null
     */
    public function getRequestUriDomainName()
    {
        return $this->requestUriDomainName;
    }
    /**
     * Set requestUriDomainName value
     * @param string $requestUriDomainName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setRequestUriDomainName($requestUriDomainName = null)
    {
        // validation for constraint: string
        if (!is_null($requestUriDomainName) && !is_string($requestUriDomainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestUriDomainName, true), gettype($requestUriDomainName)), __LINE__);
        }
        $this->requestUriDomainName = $requestUriDomainName;
        return $this;
    }
    /**
     * Get enableCiscoRecordingQsigTunneling value
     * @return string|null
     */
    public function getEnableCiscoRecordingQsigTunneling()
    {
        return $this->enableCiscoRecordingQsigTunneling;
    }
    /**
     * Set enableCiscoRecordingQsigTunneling value
     * @param string $enableCiscoRecordingQsigTunneling
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setEnableCiscoRecordingQsigTunneling($enableCiscoRecordingQsigTunneling = null)
    {
        // validation for constraint: string
        if (!is_null($enableCiscoRecordingQsigTunneling) && !is_string($enableCiscoRecordingQsigTunneling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableCiscoRecordingQsigTunneling, true), gettype($enableCiscoRecordingQsigTunneling)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableCiscoRecordingQsigTunneling) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableCiscoRecordingQsigTunneling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableCiscoRecordingQsigTunneling, true)), __LINE__);
        }
        $this->enableCiscoRecordingQsigTunneling = $enableCiscoRecordingQsigTunneling;
        return $this;
    }
    /**
     * Get calledPartyUnknownTransformationCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartyUnknownTransformationCssName()
    {
        return $this->calledPartyUnknownTransformationCssName;
    }
    /**
     * Set calledPartyUnknownTransformationCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setCalledPartyUnknownTransformationCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName = null)
    {
        $this->calledPartyUnknownTransformationCssName = $calledPartyUnknownTransformationCssName;
        return $this;
    }
    /**
     * Get calledPartyUnknownPrefix value
     * @return string|null
     */
    public function getCalledPartyUnknownPrefix()
    {
        return $this->calledPartyUnknownPrefix;
    }
    /**
     * Set calledPartyUnknownPrefix value
     * @param string $calledPartyUnknownPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setCalledPartyUnknownPrefix($calledPartyUnknownPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyUnknownPrefix) && !is_string($calledPartyUnknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartyUnknownPrefix, true), gettype($calledPartyUnknownPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($calledPartyUnknownPrefix) && mb_strlen($calledPartyUnknownPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($calledPartyUnknownPrefix)), __LINE__);
        }
        $this->calledPartyUnknownPrefix = $calledPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get calledPartyUnknownStripDigits value
     * @return string|null
     */
    public function getCalledPartyUnknownStripDigits()
    {
        return $this->calledPartyUnknownStripDigits;
    }
    /**
     * Set calledPartyUnknownStripDigits value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyUnknownStripDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($calledPartyUnknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($calledPartyUnknownStripDigits) ? implode(', ', $calledPartyUnknownStripDigits) : var_export($calledPartyUnknownStripDigits, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->calledPartyUnknownStripDigits = $calledPartyUnknownStripDigits;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssUnkn()
    {
        return $this->useDevicePoolCalledCssUnkn;
    }
    /**
     * Set useDevicePoolCalledCssUnkn value
     * @param string $useDevicePoolCalledCssUnkn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn = null)
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCalledCssUnkn) && !is_string($useDevicePoolCalledCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCalledCssUnkn, true), gettype($useDevicePoolCalledCssUnkn)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCalledCssUnkn) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCalledCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCalledCssUnkn, true)), __LINE__);
        }
        $this->useDevicePoolCalledCssUnkn = $useDevicePoolCalledCssUnkn;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setConfidentialAccess(\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !(is_int($ctiid) || ctype_digit($ctiid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ctiid, true), gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunk
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
