<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSipRoutePattern StructType
 * @subpackage Structs
 */
class LSipRoutePattern extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The blockEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $blockEnable;
    /**
     * The callingPartyTransformationMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The useCallingPartyPhoneMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useCallingPartyPhoneMask;
    /**
     * The callingPartyPrefixDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The callingLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedNamePresentationBit;
    /**
     * The sipTrunkName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * The dnOrPatternIpv6
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dnOrPatternIpv6;
    /**
     * The routeOnUserPart
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $routeOnUserPart;
    /**
     * The useCallerCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useCallerCss;
    /**
     * The domainRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $domainRoutingCssName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LSipRoutePattern
     * @uses LSipRoutePattern::setPattern()
     * @uses LSipRoutePattern::setDescription()
     * @uses LSipRoutePattern::setUsage()
     * @uses LSipRoutePattern::setRoutePartitionName()
     * @uses LSipRoutePattern::setBlockEnable()
     * @uses LSipRoutePattern::setCallingPartyTransformationMask()
     * @uses LSipRoutePattern::setUseCallingPartyPhoneMask()
     * @uses LSipRoutePattern::setCallingPartyPrefixDigits()
     * @uses LSipRoutePattern::setCallingLinePresentationBit()
     * @uses LSipRoutePattern::setCallingNamePresentationBit()
     * @uses LSipRoutePattern::setConnectedLinePresentationBit()
     * @uses LSipRoutePattern::setConnectedNamePresentationBit()
     * @uses LSipRoutePattern::setSipTrunkName()
     * @uses LSipRoutePattern::setDnOrPatternIpv6()
     * @uses LSipRoutePattern::setRouteOnUserPart()
     * @uses LSipRoutePattern::setUseCallerCss()
     * @uses LSipRoutePattern::setDomainRoutingCssName()
     * @uses LSipRoutePattern::setUuid()
     * @param string $pattern
     * @param string $description
     * @param string $usage
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param string $blockEnable
     * @param string $callingPartyTransformationMask
     * @param string $useCallingPartyPhoneMask
     * @param string $callingPartyPrefixDigits
     * @param string $callingLinePresentationBit
     * @param string $callingNamePresentationBit
     * @param string $connectedLinePresentationBit
     * @param string $connectedNamePresentationBit
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     * @param string $dnOrPatternIpv6
     * @param string $routeOnUserPart
     * @param string $useCallerCss
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $domainRoutingCssName
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, $usage = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, $blockEnable = null, $callingPartyTransformationMask = null, $useCallingPartyPhoneMask = null, $callingPartyPrefixDigits = null, $callingLinePresentationBit = null, $callingNamePresentationBit = null, $connectedLinePresentationBit = null, $connectedNamePresentationBit = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null, $dnOrPatternIpv6 = null, $routeOnUserPart = null, $useCallerCss = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $domainRoutingCssName = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setBlockEnable($blockEnable)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setSipTrunkName($sipTrunkName)
            ->setDnOrPatternIpv6($dnOrPatternIpv6)
            ->setRouteOnUserPart($routeOnUserPart)
            ->setUseCallerCss($useCallerCss)
            ->setDomainRoutingCssName($domainRoutingCssName)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage', is_array($usage) ? implode(', ', $usage) : var_export($usage, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::getValidValues())), __LINE__);
        }
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setRoutePartitionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get blockEnable value
     * @return string|null
     */
    public function getBlockEnable()
    {
        return $this->blockEnable;
    }
    /**
     * Set blockEnable value
     * @param string $blockEnable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setBlockEnable($blockEnable = null)
    {
        // validation for constraint: string
        if (!is_null($blockEnable) && !is_string($blockEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blockEnable, true), gettype($blockEnable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($blockEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $blockEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($blockEnable, true)), __LINE__);
        }
        $this->blockEnable = $blockEnable;
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return $this->callingPartyTransformationMask;
    }
    /**
     * Set callingPartyTransformationMask value
     * @param string $callingPartyTransformationMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyTransformationMask) && !is_string($callingPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyTransformationMask, true), gettype($callingPartyTransformationMask)), __LINE__);
        }
        $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return string|null
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useCallingPartyPhoneMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setUseCallingPartyPhoneMask($useCallingPartyPhoneMask = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($useCallingPartyPhoneMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($useCallingPartyPhoneMask) ? implode(', ', $useCallingPartyPhoneMask) : var_export($useCallingPartyPhoneMask, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return $this->callingPartyPrefixDigits;
    }
    /**
     * Set callingPartyPrefixDigits value
     * @param string $callingPartyPrefixDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyPrefixDigits) && !is_string($callingPartyPrefixDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyPrefixDigits, true), gettype($callingPartyPrefixDigits)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callingPartyPrefixDigits) && mb_strlen($callingPartyPrefixDigits) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callingPartyPrefixDigits)), __LINE__);
        }
        $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return string|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLinePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setCallingLinePresentationBit($callingLinePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($callingLinePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($callingLinePresentationBit) ? implode(', ', $callingLinePresentationBit) : var_export($callingLinePresentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return string|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingNamePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setCallingNamePresentationBit($callingNamePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($callingNamePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($callingNamePresentationBit) ? implode(', ', $callingNamePresentationBit) : var_export($callingNamePresentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return string|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedLinePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setConnectedLinePresentationBit($connectedLinePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($connectedLinePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($connectedLinePresentationBit) ? implode(', ', $connectedLinePresentationBit) : var_export($connectedLinePresentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return string|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedNamePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setConnectedNamePresentationBit($connectedNamePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($connectedNamePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($connectedNamePresentationBit) ? implode(', ', $connectedNamePresentationBit) : var_export($connectedNamePresentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setSipTrunkName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get dnOrPatternIpv6 value
     * @return string|null
     */
    public function getDnOrPatternIpv6()
    {
        return $this->dnOrPatternIpv6;
    }
    /**
     * Set dnOrPatternIpv6 value
     * @param string $dnOrPatternIpv6
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setDnOrPatternIpv6($dnOrPatternIpv6 = null)
    {
        // validation for constraint: string
        if (!is_null($dnOrPatternIpv6) && !is_string($dnOrPatternIpv6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnOrPatternIpv6, true), gettype($dnOrPatternIpv6)), __LINE__);
        }
        $this->dnOrPatternIpv6 = $dnOrPatternIpv6;
        return $this;
    }
    /**
     * Get routeOnUserPart value
     * @return string|null
     */
    public function getRouteOnUserPart()
    {
        return $this->routeOnUserPart;
    }
    /**
     * Set routeOnUserPart value
     * @param string $routeOnUserPart
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setRouteOnUserPart($routeOnUserPart = null)
    {
        // validation for constraint: string
        if (!is_null($routeOnUserPart) && !is_string($routeOnUserPart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routeOnUserPart, true), gettype($routeOnUserPart)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($routeOnUserPart) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $routeOnUserPart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($routeOnUserPart, true)), __LINE__);
        }
        $this->routeOnUserPart = $routeOnUserPart;
        return $this;
    }
    /**
     * Get useCallerCss value
     * @return string|null
     */
    public function getUseCallerCss()
    {
        return $this->useCallerCss;
    }
    /**
     * Set useCallerCss value
     * @param string $useCallerCss
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setUseCallerCss($useCallerCss = null)
    {
        // validation for constraint: string
        if (!is_null($useCallerCss) && !is_string($useCallerCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useCallerCss, true), gettype($useCallerCss)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useCallerCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useCallerCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useCallerCss, true)), __LINE__);
        }
        $this->useCallerCss = $useCallerCss;
        return $this;
    }
    /**
     * Get domainRoutingCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDomainRoutingCssName()
    {
        return $this->domainRoutingCssName;
    }
    /**
     * Set domainRoutingCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $domainRoutingCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setDomainRoutingCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $domainRoutingCssName = null)
    {
        $this->domainRoutingCssName = $domainRoutingCssName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipRoutePattern
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
