<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRouteFilterMember StructType
 * @subpackage Structs
 */
class LRouteFilterMember extends AbstractStructBase
{
    /**
     * The dialPlanTagName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dialPlanTagName;
    /**
     * The digits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digits;
    /**
     * The operator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $operator;
    /**
     * The priority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $priority;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRouteFilterMember
     * @uses LRouteFilterMember::setDialPlanTagName()
     * @uses LRouteFilterMember::setDigits()
     * @uses LRouteFilterMember::setOperator()
     * @uses LRouteFilterMember::setPriority()
     * @uses LRouteFilterMember::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanTagName
     * @param string $digits
     * @param string $operator
     * @param string $priority
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanTagName = null, $digits = null, $operator = null, $priority = null, $uuid = null)
    {
        $this
            ->setDialPlanTagName($dialPlanTagName)
            ->setDigits($digits)
            ->setOperator($operator)
            ->setPriority($priority)
            ->setUuid($uuid);
    }
    /**
     * Get dialPlanTagName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDialPlanTagName()
    {
        return $this->dialPlanTagName;
    }
    /**
     * Set dialPlanTagName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanTagName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRouteFilterMember
     */
    public function setDialPlanTagName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanTagName = null)
    {
        $this->dialPlanTagName = $dialPlanTagName;
        return $this;
    }
    /**
     * Get digits value
     * @return string|null
     */
    public function getDigits()
    {
        return $this->digits;
    }
    /**
     * Set digits value
     * @param string $digits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRouteFilterMember
     */
    public function setDigits($digits = null)
    {
        // validation for constraint: string
        if (!is_null($digits) && !is_string($digits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digits, true), gettype($digits)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($digits) && mb_strlen($digits) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($digits)), __LINE__);
        }
        $this->digits = $digits;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XOperator::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRouteFilterMember
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XOperator', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XOperator::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
    /**
     * Get priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRouteFilterMember
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($priority) ? implode(', ', $priority) : var_export($priority, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRouteFilterMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
