<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LResourcePriorityNamespace StructType
 * @subpackage Structs
 */
class LResourcePriorityNamespace extends AbstractStructBase
{
    /**
     * The namespace
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $namespace;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LResourcePriorityNamespace
     * @uses LResourcePriorityNamespace::setNamespace()
     * @uses LResourcePriorityNamespace::setDescription()
     * @uses LResourcePriorityNamespace::setUuid()
     * @param string $namespace
     * @param string $description
     * @param string $uuid
     */
    public function __construct($namespace = null, $description = null, $uuid = null)
    {
        $this
            ->setNamespace($namespace)
            ->setDescription($description)
            ->setUuid($uuid);
    }
    /**
     * Get namespace value
     * @return string|null
     */
    public function getNamespace()
    {
        return $this->namespace;
    }
    /**
     * Set namespace value
     * @param string $namespace
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LResourcePriorityNamespace
     */
    public function setNamespace($namespace = null)
    {
        // validation for constraint: string
        if (!is_null($namespace) && !is_string($namespace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namespace, true), gettype($namespace)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($namespace) && mb_strlen($namespace) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($namespace)), __LINE__);
        }
        $this->namespace = $namespace;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LResourcePriorityNamespace
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LResourcePriorityNamespace
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
