<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRegionRelationship StructType
 * @subpackage Structs
 */
class LRegionRelationship extends AbstractStructBase
{
    /**
     * The regionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $regionName;
    /**
     * The bandwidth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bandwidth;
    /**
     * The videoBandwidth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $videoBandwidth;
    /**
     * The lossyNetwork
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lossyNetwork;
    /**
     * The codecPreference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $codecPreference;
    /**
     * The immersiveVideoBandwidth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $immersiveVideoBandwidth;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRegionRelationship
     * @uses LRegionRelationship::setRegionName()
     * @uses LRegionRelationship::setBandwidth()
     * @uses LRegionRelationship::setVideoBandwidth()
     * @uses LRegionRelationship::setLossyNetwork()
     * @uses LRegionRelationship::setCodecPreference()
     * @uses LRegionRelationship::setImmersiveVideoBandwidth()
     * @uses LRegionRelationship::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionName
     * @param string $bandwidth
     * @param string $videoBandwidth
     * @param string $lossyNetwork
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $codecPreference
     * @param string $immersiveVideoBandwidth
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionName = null, $bandwidth = null, $videoBandwidth = null, $lossyNetwork = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $codecPreference = null, $immersiveVideoBandwidth = null, $uuid = null)
    {
        $this
            ->setRegionName($regionName)
            ->setBandwidth($bandwidth)
            ->setVideoBandwidth($videoBandwidth)
            ->setLossyNetwork($lossyNetwork)
            ->setCodecPreference($codecPreference)
            ->setImmersiveVideoBandwidth($immersiveVideoBandwidth)
            ->setUuid($uuid);
    }
    /**
     * Get regionName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRegionName()
    {
        return $this->regionName;
    }
    /**
     * Set regionName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRegionRelationship
     */
    public function setRegionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionName = null)
    {
        $this->regionName = $regionName;
        return $this;
    }
    /**
     * Get bandwidth value
     * @return string|null
     */
    public function getBandwidth()
    {
        return $this->bandwidth;
    }
    /**
     * Set bandwidth value
     * @param string $bandwidth
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRegionRelationship
     */
    public function setBandwidth($bandwidth = null)
    {
        // validation for constraint: string
        if (!is_null($bandwidth) && !is_string($bandwidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bandwidth, true), gettype($bandwidth)), __LINE__);
        }
        $this->bandwidth = $bandwidth;
        return $this;
    }
    /**
     * Get videoBandwidth value
     * @return string|null
     */
    public function getVideoBandwidth()
    {
        return $this->videoBandwidth;
    }
    /**
     * Set videoBandwidth value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoBandwidth
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRegionRelationship
     */
    public function setVideoBandwidth($videoBandwidth = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($videoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($videoBandwidth) ? implode(', ', $videoBandwidth) : var_export($videoBandwidth, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->videoBandwidth = $videoBandwidth;
        return $this;
    }
    /**
     * Get lossyNetwork value
     * @return string|null
     */
    public function getLossyNetwork()
    {
        return $this->lossyNetwork;
    }
    /**
     * Set lossyNetwork value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XLossyNetwork::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XLossyNetwork::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lossyNetwork
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRegionRelationship
     */
    public function setLossyNetwork($lossyNetwork = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XLossyNetwork::valueIsValid($lossyNetwork)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XLossyNetwork', is_array($lossyNetwork) ? implode(', ', $lossyNetwork) : var_export($lossyNetwork, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XLossyNetwork::getValidValues())), __LINE__);
        }
        $this->lossyNetwork = $lossyNetwork;
        return $this;
    }
    /**
     * Get codecPreference value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCodecPreference()
    {
        return $this->codecPreference;
    }
    /**
     * Set codecPreference value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $codecPreference
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRegionRelationship
     */
    public function setCodecPreference(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $codecPreference = null)
    {
        $this->codecPreference = $codecPreference;
        return $this;
    }
    /**
     * Get immersiveVideoBandwidth value
     * @return string|null
     */
    public function getImmersiveVideoBandwidth()
    {
        return $this->immersiveVideoBandwidth;
    }
    /**
     * Set immersiveVideoBandwidth value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $immersiveVideoBandwidth
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRegionRelationship
     */
    public function setImmersiveVideoBandwidth($immersiveVideoBandwidth = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($immersiveVideoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($immersiveVideoBandwidth) ? implode(', ', $immersiveVideoBandwidth) : var_export($immersiveVideoBandwidth, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->immersiveVideoBandwidth = $immersiveVideoBandwidth;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRegionRelationship
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
