<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LProcessNode StructType
 * @subpackage Structs
 */
class LProcessNode extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The primary hostname of the process node.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The mac
     * Meta information extracted from the WSDL
     * - documentation: The mac address of the host.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]|[a-f]|[A-F]){12}
     * @var string
     */
    public $mac;
    /**
     * The ipv6Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipv6Name;
    /**
     * The nodeUsage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nodeUsage;
    /**
     * The lbmHubGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $lbmHubGroup;
    /**
     * The processNodeRole
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $processNodeRole;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LProcessNode
     * @uses LProcessNode::setName()
     * @uses LProcessNode::setDescription()
     * @uses LProcessNode::setMac()
     * @uses LProcessNode::setIpv6Name()
     * @uses LProcessNode::setNodeUsage()
     * @uses LProcessNode::setLbmHubGroup()
     * @uses LProcessNode::setProcessNodeRole()
     * @uses LProcessNode::setUuid()
     * @param string $name
     * @param string $description
     * @param string $mac
     * @param string $ipv6Name
     * @param string $nodeUsage
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup
     * @param string $processNodeRole
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $mac = null, $ipv6Name = null, $nodeUsage = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup = null, $processNodeRole = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setMac($mac)
            ->setIpv6Name($ipv6Name)
            ->setNodeUsage($nodeUsage)
            ->setLbmHubGroup($lbmHubGroup)
            ->setProcessNodeRole($processNodeRole)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LProcessNode
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($name) && mb_strlen($name) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LProcessNode
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($description) && mb_strlen($description) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get mac value
     * @return string|null
     */
    public function getMac()
    {
        return $this->mac;
    }
    /**
     * Set mac value
     * @param string $mac
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LProcessNode
     */
    public function setMac($mac = null)
    {
        // validation for constraint: string
        if (!is_null($mac) && !is_string($mac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mac, true), gettype($mac)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]|[a-f]|[A-F]){12})
        if (!is_null($mac) && !preg_match('/([0-9]|[a-f]|[A-F]){12}/', $mac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]|[a-f]|[A-F]){12}', var_export($mac, true)), __LINE__);
        }
        $this->mac = $mac;
        return $this;
    }
    /**
     * Get ipv6Name value
     * @return string|null
     */
    public function getIpv6Name()
    {
        return $this->ipv6Name;
    }
    /**
     * Set ipv6Name value
     * @param string $ipv6Name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LProcessNode
     */
    public function setIpv6Name($ipv6Name = null)
    {
        // validation for constraint: string
        if (!is_null($ipv6Name) && !is_string($ipv6Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipv6Name, true), gettype($ipv6Name)), __LINE__);
        }
        $this->ipv6Name = $ipv6Name;
        return $this;
    }
    /**
     * Get nodeUsage value
     * @return string|null
     */
    public function getNodeUsage()
    {
        return $this->nodeUsage;
    }
    /**
     * Set nodeUsage value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNodeUsage::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNodeUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nodeUsage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LProcessNode
     */
    public function setNodeUsage($nodeUsage = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNodeUsage::valueIsValid($nodeUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNodeUsage', is_array($nodeUsage) ? implode(', ', $nodeUsage) : var_export($nodeUsage, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNodeUsage::getValidValues())), __LINE__);
        }
        $this->nodeUsage = $nodeUsage;
        return $this;
    }
    /**
     * Get lbmHubGroup value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLbmHubGroup()
    {
        return $this->lbmHubGroup;
    }
    /**
     * Set lbmHubGroup value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LProcessNode
     */
    public function setLbmHubGroup(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup = null)
    {
        $this->lbmHubGroup = $lbmHubGroup;
        return $this;
    }
    /**
     * Get processNodeRole value
     * @return string|null
     */
    public function getProcessNodeRole()
    {
        return $this->processNodeRole;
    }
    /**
     * Set processNodeRole value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProcessNodeRole::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProcessNodeRole::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $processNodeRole
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LProcessNode
     */
    public function setProcessNodeRole($processNodeRole = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XProcessNodeRole::valueIsValid($processNodeRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XProcessNodeRole', is_array($processNodeRole) ? implode(', ', $processNodeRole) : var_export($processNodeRole, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XProcessNodeRole::getValidValues())), __LINE__);
        }
        $this->processNodeRole = $processNodeRole;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LProcessNode
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
