<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LPhoneLine StructType
 * @subpackage Structs
 */
class LPhoneLine extends AbstractStructBase
{
    /**
     * The index
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The display
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $display;
    /**
     * The dirn
     * Meta information extracted from the WSDL
     * - documentation: Only uuid attribute is returned in response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\LDirn
     */
    public $dirn;
    /**
     * The ringSetting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSetting;
    /**
     * The consecutiveRingSetting
     * Meta information extracted from the WSDL
     * - documentation: Consecutive Rings Setting. Replaces the consective ring setting on IPPhone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $consecutiveRingSetting;
    /**
     * The ringSettingIdlePickupAlert
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for IP Phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSettingIdlePickupAlert;
    /**
     * The ringSettingActivePickupAlert
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for IP Phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSettingActivePickupAlert;
    /**
     * The displayAscii
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $displayAscii;
    /**
     * The e164Mask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $e164Mask;
    /**
     * The dialPlanWizardId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardId;
    /**
     * The mwlPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mwlPolicy;
    /**
     * The maxNumCalls
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxNumCalls;
    /**
     * The busyTrigger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $busyTrigger;
    /**
     * The callInfoDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay
     */
    public $callInfoDisplay;
    /**
     * The recordingProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $recordingProfileName;
    /**
     * The monitoringCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $monitoringCssName;
    /**
     * The recordingFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordingFlag;
    /**
     * The audibleMwi
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for gatewayEndpointAnalogAccess and CiscoCatalyst600024PortFXSGateway
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $audibleMwi;
    /**
     * The speedDial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $speedDial;
    /**
     * The partitionUsage
     * Meta information extracted from the WSDL
     * - documentation: This tag cannot be modified. It can only be specified in the add request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partitionUsage;
    /**
     * The associatedEndusers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers
     */
    public $associatedEndusers;
    /**
     * The missedCallLogging
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $missedCallLogging;
    /**
     * The recordingMediaSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordingMediaSource;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LPhoneLine
     * @uses LPhoneLine::setIndex()
     * @uses LPhoneLine::setLabel()
     * @uses LPhoneLine::setDisplay()
     * @uses LPhoneLine::setDirn()
     * @uses LPhoneLine::setRingSetting()
     * @uses LPhoneLine::setConsecutiveRingSetting()
     * @uses LPhoneLine::setRingSettingIdlePickupAlert()
     * @uses LPhoneLine::setRingSettingActivePickupAlert()
     * @uses LPhoneLine::setDisplayAscii()
     * @uses LPhoneLine::setE164Mask()
     * @uses LPhoneLine::setDialPlanWizardId()
     * @uses LPhoneLine::setMwlPolicy()
     * @uses LPhoneLine::setMaxNumCalls()
     * @uses LPhoneLine::setBusyTrigger()
     * @uses LPhoneLine::setCallInfoDisplay()
     * @uses LPhoneLine::setRecordingProfileName()
     * @uses LPhoneLine::setMonitoringCssName()
     * @uses LPhoneLine::setRecordingFlag()
     * @uses LPhoneLine::setAudibleMwi()
     * @uses LPhoneLine::setSpeedDial()
     * @uses LPhoneLine::setPartitionUsage()
     * @uses LPhoneLine::setAssociatedEndusers()
     * @uses LPhoneLine::setMissedCallLogging()
     * @uses LPhoneLine::setRecordingMediaSource()
     * @uses LPhoneLine::setCtiid()
     * @uses LPhoneLine::setUuid()
     * @param string $index
     * @param string $label
     * @param string $display
     * @param \Losc\CucmBundle\Model\Webservice\StructType\LDirn $dirn
     * @param string $ringSetting
     * @param string $consecutiveRingSetting
     * @param string $ringSettingIdlePickupAlert
     * @param string $ringSettingActivePickupAlert
     * @param string $displayAscii
     * @param string $e164Mask
     * @param string $dialPlanWizardId
     * @param string $mwlPolicy
     * @param string $maxNumCalls
     * @param string $busyTrigger
     * @param \Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay $callInfoDisplay
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingProfileName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $monitoringCssName
     * @param string $recordingFlag
     * @param string $audibleMwi
     * @param string $speedDial
     * @param string $partitionUsage
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers $associatedEndusers
     * @param string $missedCallLogging
     * @param string $recordingMediaSource
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($index = null, $label = null, $display = null, \Losc\CucmBundle\Model\Webservice\StructType\LDirn $dirn = null, $ringSetting = null, $consecutiveRingSetting = null, $ringSettingIdlePickupAlert = null, $ringSettingActivePickupAlert = null, $displayAscii = null, $e164Mask = null, $dialPlanWizardId = null, $mwlPolicy = null, $maxNumCalls = null, $busyTrigger = null, \Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay $callInfoDisplay = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingProfileName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $monitoringCssName = null, $recordingFlag = null, $audibleMwi = null, $speedDial = null, $partitionUsage = null, \Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers $associatedEndusers = null, $missedCallLogging = null, $recordingMediaSource = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setIndex($index)
            ->setLabel($label)
            ->setDisplay($display)
            ->setDirn($dirn)
            ->setRingSetting($ringSetting)
            ->setConsecutiveRingSetting($consecutiveRingSetting)
            ->setRingSettingIdlePickupAlert($ringSettingIdlePickupAlert)
            ->setRingSettingActivePickupAlert($ringSettingActivePickupAlert)
            ->setDisplayAscii($displayAscii)
            ->setE164Mask($e164Mask)
            ->setDialPlanWizardId($dialPlanWizardId)
            ->setMwlPolicy($mwlPolicy)
            ->setMaxNumCalls($maxNumCalls)
            ->setBusyTrigger($busyTrigger)
            ->setCallInfoDisplay($callInfoDisplay)
            ->setRecordingProfileName($recordingProfileName)
            ->setMonitoringCssName($monitoringCssName)
            ->setRecordingFlag($recordingFlag)
            ->setAudibleMwi($audibleMwi)
            ->setSpeedDial($speedDial)
            ->setPartitionUsage($partitionUsage)
            ->setAssociatedEndusers($associatedEndusers)
            ->setMissedCallLogging($missedCallLogging)
            ->setRecordingMediaSource($recordingMediaSource)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($index) ? implode(', ', $index) : var_export($index, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($label) && mb_strlen($label) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get display value
     * @return string|null
     */
    public function getDisplay()
    {
        return $this->display;
    }
    /**
     * Set display value
     * @param string $display
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setDisplay($display = null)
    {
        // validation for constraint: string
        if (!is_null($display) && !is_string($display)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($display, true), gettype($display)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($display) && mb_strlen($display) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($display)), __LINE__);
        }
        $this->display = $display;
        return $this;
    }
    /**
     * Get dirn value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirn|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\LDirn $dirn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setDirn(\Losc\CucmBundle\Model\Webservice\StructType\LDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get ringSetting value
     * @return string|null
     */
    public function getRingSetting()
    {
        return $this->ringSetting;
    }
    /**
     * Set ringSetting value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSetting
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setRingSetting($ringSetting = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::valueIsValid($ringSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting', is_array($ringSetting) ? implode(', ', $ringSetting) : var_export($ringSetting, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->ringSetting = $ringSetting;
        return $this;
    }
    /**
     * Get consecutiveRingSetting value
     * @return string|null
     */
    public function getConsecutiveRingSetting()
    {
        return $this->consecutiveRingSetting;
    }
    /**
     * Set consecutiveRingSetting value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $consecutiveRingSetting
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setConsecutiveRingSetting($consecutiveRingSetting = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::valueIsValid($consecutiveRingSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting', is_array($consecutiveRingSetting) ? implode(', ', $consecutiveRingSetting) : var_export($consecutiveRingSetting, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->consecutiveRingSetting = $consecutiveRingSetting;
        return $this;
    }
    /**
     * Get ringSettingIdlePickupAlert value
     * @return string|null
     */
    public function getRingSettingIdlePickupAlert()
    {
        return $this->ringSettingIdlePickupAlert;
    }
    /**
     * Set ringSettingIdlePickupAlert value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingIdlePickupAlert
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setRingSettingIdlePickupAlert($ringSettingIdlePickupAlert = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::valueIsValid($ringSettingIdlePickupAlert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting', is_array($ringSettingIdlePickupAlert) ? implode(', ', $ringSettingIdlePickupAlert) : var_export($ringSettingIdlePickupAlert, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->ringSettingIdlePickupAlert = $ringSettingIdlePickupAlert;
        return $this;
    }
    /**
     * Get ringSettingActivePickupAlert value
     * @return string|null
     */
    public function getRingSettingActivePickupAlert()
    {
        return $this->ringSettingActivePickupAlert;
    }
    /**
     * Set ringSettingActivePickupAlert value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingActivePickupAlert
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setRingSettingActivePickupAlert($ringSettingActivePickupAlert = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::valueIsValid($ringSettingActivePickupAlert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting', is_array($ringSettingActivePickupAlert) ? implode(', ', $ringSettingActivePickupAlert) : var_export($ringSettingActivePickupAlert, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->ringSettingActivePickupAlert = $ringSettingActivePickupAlert;
        return $this;
    }
    /**
     * Get displayAscii value
     * @return string|null
     */
    public function getDisplayAscii()
    {
        return $this->displayAscii;
    }
    /**
     * Set displayAscii value
     * @param string $displayAscii
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setDisplayAscii($displayAscii = null)
    {
        // validation for constraint: string
        if (!is_null($displayAscii) && !is_string($displayAscii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayAscii, true), gettype($displayAscii)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($displayAscii) && mb_strlen($displayAscii) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($displayAscii)), __LINE__);
        }
        $this->displayAscii = $displayAscii;
        return $this;
    }
    /**
     * Get e164Mask value
     * @return string|null
     */
    public function getE164Mask()
    {
        return $this->e164Mask;
    }
    /**
     * Set e164Mask value
     * @param string $e164Mask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setE164Mask($e164Mask = null)
    {
        // validation for constraint: string
        if (!is_null($e164Mask) && !is_string($e164Mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($e164Mask, true), gettype($e164Mask)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($e164Mask) && mb_strlen($e164Mask) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($e164Mask)), __LINE__);
        }
        $this->e164Mask = $e164Mask;
        return $this;
    }
    /**
     * Get dialPlanWizardId value
     * @return string|null
     */
    public function getDialPlanWizardId()
    {
        return $this->dialPlanWizardId;
    }
    /**
     * Set dialPlanWizardId value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPlanWizardId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setDialPlanWizardId($dialPlanWizardId = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($dialPlanWizardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($dialPlanWizardId) ? implode(', ', $dialPlanWizardId) : var_export($dialPlanWizardId, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dialPlanWizardId = $dialPlanWizardId;
        return $this;
    }
    /**
     * Get mwlPolicy value
     * @return string|null
     */
    public function getMwlPolicy()
    {
        return $this->mwlPolicy;
    }
    /**
     * Set mwlPolicy value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMWLPolicy::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMWLPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mwlPolicy
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setMwlPolicy($mwlPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XMWLPolicy::valueIsValid($mwlPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XMWLPolicy', is_array($mwlPolicy) ? implode(', ', $mwlPolicy) : var_export($mwlPolicy, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XMWLPolicy::getValidValues())), __LINE__);
        }
        $this->mwlPolicy = $mwlPolicy;
        return $this;
    }
    /**
     * Get maxNumCalls value
     * @return string|null
     */
    public function getMaxNumCalls()
    {
        return $this->maxNumCalls;
    }
    /**
     * Set maxNumCalls value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxNumCalls
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setMaxNumCalls($maxNumCalls = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($maxNumCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($maxNumCalls) ? implode(', ', $maxNumCalls) : var_export($maxNumCalls, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxNumCalls = $maxNumCalls;
        return $this;
    }
    /**
     * Get busyTrigger value
     * @return string|null
     */
    public function getBusyTrigger()
    {
        return $this->busyTrigger;
    }
    /**
     * Set busyTrigger value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $busyTrigger
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setBusyTrigger($busyTrigger = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($busyTrigger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($busyTrigger) ? implode(', ', $busyTrigger) : var_export($busyTrigger, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->busyTrigger = $busyTrigger;
        return $this;
    }
    /**
     * Get callInfoDisplay value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay|null
     */
    public function getCallInfoDisplay()
    {
        return $this->callInfoDisplay;
    }
    /**
     * Set callInfoDisplay value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay $callInfoDisplay
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setCallInfoDisplay(\Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay $callInfoDisplay = null)
    {
        $this->callInfoDisplay = $callInfoDisplay;
        return $this;
    }
    /**
     * Get recordingProfileName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRecordingProfileName()
    {
        return $this->recordingProfileName;
    }
    /**
     * Set recordingProfileName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingProfileName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setRecordingProfileName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingProfileName = null)
    {
        $this->recordingProfileName = $recordingProfileName;
        return $this;
    }
    /**
     * Get monitoringCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMonitoringCssName()
    {
        return $this->monitoringCssName;
    }
    /**
     * Set monitoringCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $monitoringCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setMonitoringCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $monitoringCssName = null)
    {
        $this->monitoringCssName = $monitoringCssName;
        return $this;
    }
    /**
     * Get recordingFlag value
     * @return string|null
     */
    public function getRecordingFlag()
    {
        return $this->recordingFlag;
    }
    /**
     * Set recordingFlag value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRecordingFlag::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRecordingFlag::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordingFlag
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setRecordingFlag($recordingFlag = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XRecordingFlag::valueIsValid($recordingFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XRecordingFlag', is_array($recordingFlag) ? implode(', ', $recordingFlag) : var_export($recordingFlag, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XRecordingFlag::getValidValues())), __LINE__);
        }
        $this->recordingFlag = $recordingFlag;
        return $this;
    }
    /**
     * Get audibleMwi value
     * @return string|null
     */
    public function getAudibleMwi()
    {
        return $this->audibleMwi;
    }
    /**
     * Set audibleMwi value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $audibleMwi
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setAudibleMwi($audibleMwi = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($audibleMwi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($audibleMwi) ? implode(', ', $audibleMwi) : var_export($audibleMwi, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->audibleMwi = $audibleMwi;
        return $this;
    }
    /**
     * Get speedDial value
     * @return string|null
     */
    public function getSpeedDial()
    {
        return $this->speedDial;
    }
    /**
     * Set speedDial value
     * @param string $speedDial
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setSpeedDial($speedDial = null)
    {
        // validation for constraint: string
        if (!is_null($speedDial) && !is_string($speedDial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($speedDial, true), gettype($speedDial)), __LINE__);
        }
        $this->speedDial = $speedDial;
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return string|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partitionUsage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setPartitionUsage($partitionUsage = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage::valueIsValid($partitionUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage', is_array($partitionUsage) ? implode(', ', $partitionUsage) : var_export($partitionUsage, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage::getValidValues())), __LINE__);
        }
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
    /**
     * Get associatedEndusers value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers|null
     */
    public function getAssociatedEndusers()
    {
        return $this->associatedEndusers;
    }
    /**
     * Set associatedEndusers value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers $associatedEndusers
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setAssociatedEndusers(\Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers $associatedEndusers = null)
    {
        $this->associatedEndusers = $associatedEndusers;
        return $this;
    }
    /**
     * Get missedCallLogging value
     * @return string|null
     */
    public function getMissedCallLogging()
    {
        return $this->missedCallLogging;
    }
    /**
     * Set missedCallLogging value
     * @param string $missedCallLogging
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setMissedCallLogging($missedCallLogging = null)
    {
        // validation for constraint: string
        if (!is_null($missedCallLogging) && !is_string($missedCallLogging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($missedCallLogging, true), gettype($missedCallLogging)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($missedCallLogging) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $missedCallLogging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($missedCallLogging, true)), __LINE__);
        }
        $this->missedCallLogging = $missedCallLogging;
        return $this;
    }
    /**
     * Get recordingMediaSource value
     * @return string|null
     */
    public function getRecordingMediaSource()
    {
        return $this->recordingMediaSource;
    }
    /**
     * Set recordingMediaSource value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPreferredMediaSource::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPreferredMediaSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordingMediaSource
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setRecordingMediaSource($recordingMediaSource = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPreferredMediaSource::valueIsValid($recordingMediaSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPreferredMediaSource', is_array($recordingMediaSource) ? implode(', ', $recordingMediaSource) : var_export($recordingMediaSource, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPreferredMediaSource::getValidValues())), __LINE__);
        }
        $this->recordingMediaSource = $recordingMediaSource;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !(is_int($ctiid) || ctype_digit($ctiid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ctiid, true), gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPhoneLine
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
