<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LPatternMember StructType
 * @subpackage Structs
 */
class LPatternMember extends AbstractStructBase
{
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The dialParameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\DialParameters
     */
    public $dialParameters;
    /**
     * The selectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $selectionOrder;
    /**
     * Constructor method for LPatternMember
     * @uses LPatternMember::setDescription()
     * @uses LPatternMember::setDialParameters()
     * @uses LPatternMember::setSelectionOrder()
     * @param string $description
     * @param \Losc\CucmBundle\Model\Webservice\StructType\DialParameters $dialParameters
     * @param string $selectionOrder
     */
    public function __construct($description = null, \Losc\CucmBundle\Model\Webservice\StructType\DialParameters $dialParameters = null, $selectionOrder = null)
    {
        $this
            ->setDescription($description)
            ->setDialParameters($dialParameters)
            ->setSelectionOrder($selectionOrder);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPatternMember
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get dialParameters value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\DialParameters|null
     */
    public function getDialParameters()
    {
        return $this->dialParameters;
    }
    /**
     * Set dialParameters value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\DialParameters $dialParameters
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPatternMember
     */
    public function setDialParameters(\Losc\CucmBundle\Model\Webservice\StructType\DialParameters $dialParameters = null)
    {
        $this->dialParameters = $dialParameters;
        return $this;
    }
    /**
     * Get selectionOrder value
     * @return string|null
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LPatternMember
     */
    public function setSelectionOrder($selectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($selectionOrder) ? implode(', ', $selectionOrder) : var_export($selectionOrder, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
}
