<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LLocationRelationship StructType
 * @subpackage Structs
 */
class LLocationRelationship extends AbstractStructBase
{
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The rsvpSetting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rsvpSetting;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LLocationRelationship
     * @uses LLocationRelationship::setLocationName()
     * @uses LLocationRelationship::setRsvpSetting()
     * @uses LLocationRelationship::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param string $rsvpSetting
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, $rsvpSetting = null, $uuid = null)
    {
        $this
            ->setLocationName($locationName)
            ->setRsvpSetting($rsvpSetting)
            ->setUuid($uuid);
    }
    /**
     * Get locationName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLocationRelationship
     */
    public function setLocationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get rsvpSetting value
     * @return string|null
     */
    public function getRsvpSetting()
    {
        return $this->rsvpSetting;
    }
    /**
     * Set rsvpSetting value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMatrixValue::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMatrixValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rsvpSetting
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLocationRelationship
     */
    public function setRsvpSetting($rsvpSetting = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XMatrixValue::valueIsValid($rsvpSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XMatrixValue', is_array($rsvpSetting) ? implode(', ', $rsvpSetting) : var_export($rsvpSetting, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XMatrixValue::getValidValues())), __LINE__);
        }
        $this->rsvpSetting = $rsvpSetting;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLocationRelationship
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
