<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LGatekeeper StructType
 * @subpackage Structs
 */
class LGatekeeper extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: From Device Table
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: From Device Table
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The rrqTimeToLive
     * Meta information extracted from the WSDL
     * - documentation: Value should be numbers in range of 30 to 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rrqTimeToLive;
    /**
     * The retryTimeout
     * Meta information extracted from the WSDL
     * - documentation: Value should be numbers in range of 30 to 600
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $retryTimeout;
    /**
     * The enableDevice
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDevice;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LGatekeeper
     * @uses LGatekeeper::setName()
     * @uses LGatekeeper::setDescription()
     * @uses LGatekeeper::setRrqTimeToLive()
     * @uses LGatekeeper::setRetryTimeout()
     * @uses LGatekeeper::setEnableDevice()
     * @uses LGatekeeper::setUuid()
     * @param string $name
     * @param string $description
     * @param string $rrqTimeToLive
     * @param string $retryTimeout
     * @param string $enableDevice
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $rrqTimeToLive = null, $retryTimeout = null, $enableDevice = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setRrqTimeToLive($rrqTimeToLive)
            ->setRetryTimeout($retryTimeout)
            ->setEnableDevice($enableDevice)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LGatekeeper
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($name) && mb_strlen($name) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LGatekeeper
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get rrqTimeToLive value
     * @return string|null
     */
    public function getRrqTimeToLive()
    {
        return $this->rrqTimeToLive;
    }
    /**
     * Set rrqTimeToLive value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rrqTimeToLive
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LGatekeeper
     */
    public function setRrqTimeToLive($rrqTimeToLive = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($rrqTimeToLive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($rrqTimeToLive) ? implode(', ', $rrqTimeToLive) : var_export($rrqTimeToLive, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->rrqTimeToLive = $rrqTimeToLive;
        return $this;
    }
    /**
     * Get retryTimeout value
     * @return string|null
     */
    public function getRetryTimeout()
    {
        return $this->retryTimeout;
    }
    /**
     * Set retryTimeout value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retryTimeout
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LGatekeeper
     */
    public function setRetryTimeout($retryTimeout = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($retryTimeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($retryTimeout) ? implode(', ', $retryTimeout) : var_export($retryTimeout, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->retryTimeout = $retryTimeout;
        return $this;
    }
    /**
     * Get enableDevice value
     * @return string|null
     */
    public function getEnableDevice()
    {
        return $this->enableDevice;
    }
    /**
     * Set enableDevice value
     * @param string $enableDevice
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LGatekeeper
     */
    public function setEnableDevice($enableDevice = null)
    {
        // validation for constraint: string
        if (!is_null($enableDevice) && !is_string($enableDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableDevice, true), gettype($enableDevice)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableDevice, true)), __LINE__);
        }
        $this->enableDevice = $enableDevice;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LGatekeeper
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
