<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LDirNumberAliasLookupandSync StructType
 * @subpackage Structs
 */
class LDirNumberAliasLookupandSync extends AbstractStructBase
{
    /**
     * The ldapConfigName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ldapConfigName;
    /**
     * The ldapManagerDisgName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ldapManagerDisgName;
    /**
     * The ldapPassword
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ldapPassword;
    /**
     * The ldapUserSearch
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ldapUserSearch;
    /**
     * The ldapDirectoryServerUsage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ldapDirectoryServerUsage;
    /**
     * The keepAliveSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $keepAliveSearch;
    /**
     * The keepAliveTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $keepAliveTime;
    /**
     * The sipAliasSuffix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipAliasSuffix;
    /**
     * The enableCachingofRecords
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableCachingofRecords;
    /**
     * The cacheSizeforAliasLookup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cacheSizeforAliasLookup;
    /**
     * The cacheAgeforAliasLookup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cacheAgeforAliasLookup;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LDirNumberAliasLookupandSync
     * @uses LDirNumberAliasLookupandSync::setLdapConfigName()
     * @uses LDirNumberAliasLookupandSync::setLdapManagerDisgName()
     * @uses LDirNumberAliasLookupandSync::setLdapPassword()
     * @uses LDirNumberAliasLookupandSync::setLdapUserSearch()
     * @uses LDirNumberAliasLookupandSync::setLdapDirectoryServerUsage()
     * @uses LDirNumberAliasLookupandSync::setKeepAliveSearch()
     * @uses LDirNumberAliasLookupandSync::setKeepAliveTime()
     * @uses LDirNumberAliasLookupandSync::setSipAliasSuffix()
     * @uses LDirNumberAliasLookupandSync::setEnableCachingofRecords()
     * @uses LDirNumberAliasLookupandSync::setCacheSizeforAliasLookup()
     * @uses LDirNumberAliasLookupandSync::setCacheAgeforAliasLookup()
     * @uses LDirNumberAliasLookupandSync::setUuid()
     * @param string $ldapConfigName
     * @param string $ldapManagerDisgName
     * @param string $ldapPassword
     * @param string $ldapUserSearch
     * @param string $ldapDirectoryServerUsage
     * @param string $keepAliveSearch
     * @param string $keepAliveTime
     * @param string $sipAliasSuffix
     * @param string $enableCachingofRecords
     * @param string $cacheSizeforAliasLookup
     * @param string $cacheAgeforAliasLookup
     * @param string $uuid
     */
    public function __construct($ldapConfigName = null, $ldapManagerDisgName = null, $ldapPassword = null, $ldapUserSearch = null, $ldapDirectoryServerUsage = null, $keepAliveSearch = null, $keepAliveTime = null, $sipAliasSuffix = null, $enableCachingofRecords = null, $cacheSizeforAliasLookup = null, $cacheAgeforAliasLookup = null, $uuid = null)
    {
        $this
            ->setLdapConfigName($ldapConfigName)
            ->setLdapManagerDisgName($ldapManagerDisgName)
            ->setLdapPassword($ldapPassword)
            ->setLdapUserSearch($ldapUserSearch)
            ->setLdapDirectoryServerUsage($ldapDirectoryServerUsage)
            ->setKeepAliveSearch($keepAliveSearch)
            ->setKeepAliveTime($keepAliveTime)
            ->setSipAliasSuffix($sipAliasSuffix)
            ->setEnableCachingofRecords($enableCachingofRecords)
            ->setCacheSizeforAliasLookup($cacheSizeforAliasLookup)
            ->setCacheAgeforAliasLookup($cacheAgeforAliasLookup)
            ->setUuid($uuid);
    }
    /**
     * Get ldapConfigName value
     * @return string|null
     */
    public function getLdapConfigName()
    {
        return $this->ldapConfigName;
    }
    /**
     * Set ldapConfigName value
     * @param string $ldapConfigName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirNumberAliasLookupandSync
     */
    public function setLdapConfigName($ldapConfigName = null)
    {
        // validation for constraint: string
        if (!is_null($ldapConfigName) && !is_string($ldapConfigName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ldapConfigName, true), gettype($ldapConfigName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ldapConfigName) && mb_strlen($ldapConfigName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($ldapConfigName)), __LINE__);
        }
        $this->ldapConfigName = $ldapConfigName;
        return $this;
    }
    /**
     * Get ldapManagerDisgName value
     * @return string|null
     */
    public function getLdapManagerDisgName()
    {
        return $this->ldapManagerDisgName;
    }
    /**
     * Set ldapManagerDisgName value
     * @param string $ldapManagerDisgName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirNumberAliasLookupandSync
     */
    public function setLdapManagerDisgName($ldapManagerDisgName = null)
    {
        // validation for constraint: string
        if (!is_null($ldapManagerDisgName) && !is_string($ldapManagerDisgName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ldapManagerDisgName, true), gettype($ldapManagerDisgName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($ldapManagerDisgName) && mb_strlen($ldapManagerDisgName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($ldapManagerDisgName)), __LINE__);
        }
        $this->ldapManagerDisgName = $ldapManagerDisgName;
        return $this;
    }
    /**
     * Get ldapPassword value
     * @return string|null
     */
    public function getLdapPassword()
    {
        return $this->ldapPassword;
    }
    /**
     * Set ldapPassword value
     * @param string $ldapPassword
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirNumberAliasLookupandSync
     */
    public function setLdapPassword($ldapPassword = null)
    {
        // validation for constraint: string
        if (!is_null($ldapPassword) && !is_string($ldapPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ldapPassword, true), gettype($ldapPassword)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($ldapPassword) && mb_strlen($ldapPassword) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($ldapPassword)), __LINE__);
        }
        $this->ldapPassword = $ldapPassword;
        return $this;
    }
    /**
     * Get ldapUserSearch value
     * @return string|null
     */
    public function getLdapUserSearch()
    {
        return $this->ldapUserSearch;
    }
    /**
     * Set ldapUserSearch value
     * @param string $ldapUserSearch
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirNumberAliasLookupandSync
     */
    public function setLdapUserSearch($ldapUserSearch = null)
    {
        // validation for constraint: string
        if (!is_null($ldapUserSearch) && !is_string($ldapUserSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ldapUserSearch, true), gettype($ldapUserSearch)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($ldapUserSearch) && mb_strlen($ldapUserSearch) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($ldapUserSearch)), __LINE__);
        }
        $this->ldapUserSearch = $ldapUserSearch;
        return $this;
    }
    /**
     * Get ldapDirectoryServerUsage value
     * @return string|null
     */
    public function getLdapDirectoryServerUsage()
    {
        return $this->ldapDirectoryServerUsage;
    }
    /**
     * Set ldapDirectoryServerUsage value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XLDAPDirectoryFunction::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XLDAPDirectoryFunction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ldapDirectoryServerUsage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirNumberAliasLookupandSync
     */
    public function setLdapDirectoryServerUsage($ldapDirectoryServerUsage = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XLDAPDirectoryFunction::valueIsValid($ldapDirectoryServerUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XLDAPDirectoryFunction', is_array($ldapDirectoryServerUsage) ? implode(', ', $ldapDirectoryServerUsage) : var_export($ldapDirectoryServerUsage, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XLDAPDirectoryFunction::getValidValues())), __LINE__);
        }
        $this->ldapDirectoryServerUsage = $ldapDirectoryServerUsage;
        return $this;
    }
    /**
     * Get keepAliveSearch value
     * @return string|null
     */
    public function getKeepAliveSearch()
    {
        return $this->keepAliveSearch;
    }
    /**
     * Set keepAliveSearch value
     * @param string $keepAliveSearch
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirNumberAliasLookupandSync
     */
    public function setKeepAliveSearch($keepAliveSearch = null)
    {
        // validation for constraint: string
        if (!is_null($keepAliveSearch) && !is_string($keepAliveSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keepAliveSearch, true), gettype($keepAliveSearch)), __LINE__);
        }
        $this->keepAliveSearch = $keepAliveSearch;
        return $this;
    }
    /**
     * Get keepAliveTime value
     * @return string|null
     */
    public function getKeepAliveTime()
    {
        return $this->keepAliveTime;
    }
    /**
     * Set keepAliveTime value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XKeepAliveTimeInterval::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XKeepAliveTimeInterval::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keepAliveTime
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirNumberAliasLookupandSync
     */
    public function setKeepAliveTime($keepAliveTime = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XKeepAliveTimeInterval::valueIsValid($keepAliveTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XKeepAliveTimeInterval', is_array($keepAliveTime) ? implode(', ', $keepAliveTime) : var_export($keepAliveTime, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XKeepAliveTimeInterval::getValidValues())), __LINE__);
        }
        $this->keepAliveTime = $keepAliveTime;
        return $this;
    }
    /**
     * Get sipAliasSuffix value
     * @return string|null
     */
    public function getSipAliasSuffix()
    {
        return $this->sipAliasSuffix;
    }
    /**
     * Set sipAliasSuffix value
     * @param string $sipAliasSuffix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirNumberAliasLookupandSync
     */
    public function setSipAliasSuffix($sipAliasSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($sipAliasSuffix) && !is_string($sipAliasSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sipAliasSuffix, true), gettype($sipAliasSuffix)), __LINE__);
        }
        $this->sipAliasSuffix = $sipAliasSuffix;
        return $this;
    }
    /**
     * Get enableCachingofRecords value
     * @return string|null
     */
    public function getEnableCachingofRecords()
    {
        return $this->enableCachingofRecords;
    }
    /**
     * Set enableCachingofRecords value
     * @param string $enableCachingofRecords
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirNumberAliasLookupandSync
     */
    public function setEnableCachingofRecords($enableCachingofRecords = null)
    {
        // validation for constraint: string
        if (!is_null($enableCachingofRecords) && !is_string($enableCachingofRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableCachingofRecords, true), gettype($enableCachingofRecords)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableCachingofRecords) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableCachingofRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableCachingofRecords, true)), __LINE__);
        }
        $this->enableCachingofRecords = $enableCachingofRecords;
        return $this;
    }
    /**
     * Get cacheSizeforAliasLookup value
     * @return string|null
     */
    public function getCacheSizeforAliasLookup()
    {
        return $this->cacheSizeforAliasLookup;
    }
    /**
     * Set cacheSizeforAliasLookup value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cacheSizeforAliasLookup
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirNumberAliasLookupandSync
     */
    public function setCacheSizeforAliasLookup($cacheSizeforAliasLookup = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($cacheSizeforAliasLookup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($cacheSizeforAliasLookup) ? implode(', ', $cacheSizeforAliasLookup) : var_export($cacheSizeforAliasLookup, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->cacheSizeforAliasLookup = $cacheSizeforAliasLookup;
        return $this;
    }
    /**
     * Get cacheAgeforAliasLookup value
     * @return string|null
     */
    public function getCacheAgeforAliasLookup()
    {
        return $this->cacheAgeforAliasLookup;
    }
    /**
     * Set cacheAgeforAliasLookup value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cacheAgeforAliasLookup
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirNumberAliasLookupandSync
     */
    public function setCacheAgeforAliasLookup($cacheAgeforAliasLookup = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($cacheAgeforAliasLookup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($cacheAgeforAliasLookup) ? implode(', ', $cacheAgeforAliasLookup) : var_export($cacheAgeforAliasLookup, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->cacheAgeforAliasLookup = $cacheAgeforAliasLookup;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirNumberAliasLookupandSync
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
