<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LDhcpServer StructType
 * @subpackage Structs
 */
class LDhcpServer extends AbstractStructBase
{
    /**
     * The processNodeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $processNodeName;
    /**
     * The primaryDnsIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $primaryDnsIpAddress;
    /**
     * The secondaryDnsIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secondaryDnsIpAddress;
    /**
     * The primaryTftpServerIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $primaryTftpServerIpAddress;
    /**
     * The secondaryTftpServerIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secondaryTftpServerIpAddress;
    /**
     * The bootstrapServerIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bootstrapServerIpAddress;
    /**
     * The domainName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $domainName;
    /**
     * The tftpServerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tftpServerName;
    /**
     * The arpCacheTimeout
     * Meta information extracted from the WSDL
     * - documentation: The valid values ranges from 0 to 1073741824.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $arpCacheTimeout;
    /**
     * The ipAddressLeaseTime
     * Meta information extracted from the WSDL
     * - documentation: The valid values ranges from 0 to 1073741824.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipAddressLeaseTime;
    /**
     * The renewalTime
     * Meta information extracted from the WSDL
     * - documentation: The valid values ranges from 0 to 1073741824.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $renewalTime;
    /**
     * The rebindingTime
     * Meta information extracted from the WSDL
     * - documentation: The valid values ranges from 0 to 1073741824.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rebindingTime;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LDhcpServer
     * @uses LDhcpServer::setProcessNodeName()
     * @uses LDhcpServer::setPrimaryDnsIpAddress()
     * @uses LDhcpServer::setSecondaryDnsIpAddress()
     * @uses LDhcpServer::setPrimaryTftpServerIpAddress()
     * @uses LDhcpServer::setSecondaryTftpServerIpAddress()
     * @uses LDhcpServer::setBootstrapServerIpAddress()
     * @uses LDhcpServer::setDomainName()
     * @uses LDhcpServer::setTftpServerName()
     * @uses LDhcpServer::setArpCacheTimeout()
     * @uses LDhcpServer::setIpAddressLeaseTime()
     * @uses LDhcpServer::setRenewalTime()
     * @uses LDhcpServer::setRebindingTime()
     * @uses LDhcpServer::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @param string $primaryDnsIpAddress
     * @param string $secondaryDnsIpAddress
     * @param string $primaryTftpServerIpAddress
     * @param string $secondaryTftpServerIpAddress
     * @param string $bootstrapServerIpAddress
     * @param string $domainName
     * @param string $tftpServerName
     * @param string $arpCacheTimeout
     * @param string $ipAddressLeaseTime
     * @param string $renewalTime
     * @param string $rebindingTime
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null, $primaryDnsIpAddress = null, $secondaryDnsIpAddress = null, $primaryTftpServerIpAddress = null, $secondaryTftpServerIpAddress = null, $bootstrapServerIpAddress = null, $domainName = null, $tftpServerName = null, $arpCacheTimeout = null, $ipAddressLeaseTime = null, $renewalTime = null, $rebindingTime = null, $uuid = null)
    {
        $this
            ->setProcessNodeName($processNodeName)
            ->setPrimaryDnsIpAddress($primaryDnsIpAddress)
            ->setSecondaryDnsIpAddress($secondaryDnsIpAddress)
            ->setPrimaryTftpServerIpAddress($primaryTftpServerIpAddress)
            ->setSecondaryTftpServerIpAddress($secondaryTftpServerIpAddress)
            ->setBootstrapServerIpAddress($bootstrapServerIpAddress)
            ->setDomainName($domainName)
            ->setTftpServerName($tftpServerName)
            ->setArpCacheTimeout($arpCacheTimeout)
            ->setIpAddressLeaseTime($ipAddressLeaseTime)
            ->setRenewalTime($renewalTime)
            ->setRebindingTime($rebindingTime)
            ->setUuid($uuid);
    }
    /**
     * Get processNodeName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDhcpServer
     */
    public function setProcessNodeName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get primaryDnsIpAddress value
     * @return string|null
     */
    public function getPrimaryDnsIpAddress()
    {
        return $this->primaryDnsIpAddress;
    }
    /**
     * Set primaryDnsIpAddress value
     * @param string $primaryDnsIpAddress
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDhcpServer
     */
    public function setPrimaryDnsIpAddress($primaryDnsIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryDnsIpAddress) && !is_string($primaryDnsIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryDnsIpAddress, true), gettype($primaryDnsIpAddress)), __LINE__);
        }
        $this->primaryDnsIpAddress = $primaryDnsIpAddress;
        return $this;
    }
    /**
     * Get secondaryDnsIpAddress value
     * @return string|null
     */
    public function getSecondaryDnsIpAddress()
    {
        return $this->secondaryDnsIpAddress;
    }
    /**
     * Set secondaryDnsIpAddress value
     * @param string $secondaryDnsIpAddress
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDhcpServer
     */
    public function setSecondaryDnsIpAddress($secondaryDnsIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryDnsIpAddress) && !is_string($secondaryDnsIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryDnsIpAddress, true), gettype($secondaryDnsIpAddress)), __LINE__);
        }
        $this->secondaryDnsIpAddress = $secondaryDnsIpAddress;
        return $this;
    }
    /**
     * Get primaryTftpServerIpAddress value
     * @return string|null
     */
    public function getPrimaryTftpServerIpAddress()
    {
        return $this->primaryTftpServerIpAddress;
    }
    /**
     * Set primaryTftpServerIpAddress value
     * @param string $primaryTftpServerIpAddress
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDhcpServer
     */
    public function setPrimaryTftpServerIpAddress($primaryTftpServerIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryTftpServerIpAddress) && !is_string($primaryTftpServerIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryTftpServerIpAddress, true), gettype($primaryTftpServerIpAddress)), __LINE__);
        }
        $this->primaryTftpServerIpAddress = $primaryTftpServerIpAddress;
        return $this;
    }
    /**
     * Get secondaryTftpServerIpAddress value
     * @return string|null
     */
    public function getSecondaryTftpServerIpAddress()
    {
        return $this->secondaryTftpServerIpAddress;
    }
    /**
     * Set secondaryTftpServerIpAddress value
     * @param string $secondaryTftpServerIpAddress
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDhcpServer
     */
    public function setSecondaryTftpServerIpAddress($secondaryTftpServerIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryTftpServerIpAddress) && !is_string($secondaryTftpServerIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryTftpServerIpAddress, true), gettype($secondaryTftpServerIpAddress)), __LINE__);
        }
        $this->secondaryTftpServerIpAddress = $secondaryTftpServerIpAddress;
        return $this;
    }
    /**
     * Get bootstrapServerIpAddress value
     * @return string|null
     */
    public function getBootstrapServerIpAddress()
    {
        return $this->bootstrapServerIpAddress;
    }
    /**
     * Set bootstrapServerIpAddress value
     * @param string $bootstrapServerIpAddress
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDhcpServer
     */
    public function setBootstrapServerIpAddress($bootstrapServerIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($bootstrapServerIpAddress) && !is_string($bootstrapServerIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bootstrapServerIpAddress, true), gettype($bootstrapServerIpAddress)), __LINE__);
        }
        $this->bootstrapServerIpAddress = $bootstrapServerIpAddress;
        return $this;
    }
    /**
     * Get domainName value
     * @return string|null
     */
    public function getDomainName()
    {
        return $this->domainName;
    }
    /**
     * Set domainName value
     * @param string $domainName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDhcpServer
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domainName, true), gettype($domainName)), __LINE__);
        }
        $this->domainName = $domainName;
        return $this;
    }
    /**
     * Get tftpServerName value
     * @return string|null
     */
    public function getTftpServerName()
    {
        return $this->tftpServerName;
    }
    /**
     * Set tftpServerName value
     * @param string $tftpServerName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDhcpServer
     */
    public function setTftpServerName($tftpServerName = null)
    {
        // validation for constraint: string
        if (!is_null($tftpServerName) && !is_string($tftpServerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tftpServerName, true), gettype($tftpServerName)), __LINE__);
        }
        $this->tftpServerName = $tftpServerName;
        return $this;
    }
    /**
     * Get arpCacheTimeout value
     * @return string|null
     */
    public function getArpCacheTimeout()
    {
        return $this->arpCacheTimeout;
    }
    /**
     * Set arpCacheTimeout value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arpCacheTimeout
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDhcpServer
     */
    public function setArpCacheTimeout($arpCacheTimeout = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($arpCacheTimeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($arpCacheTimeout) ? implode(', ', $arpCacheTimeout) : var_export($arpCacheTimeout, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->arpCacheTimeout = $arpCacheTimeout;
        return $this;
    }
    /**
     * Get ipAddressLeaseTime value
     * @return string|null
     */
    public function getIpAddressLeaseTime()
    {
        return $this->ipAddressLeaseTime;
    }
    /**
     * Set ipAddressLeaseTime value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ipAddressLeaseTime
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDhcpServer
     */
    public function setIpAddressLeaseTime($ipAddressLeaseTime = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($ipAddressLeaseTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($ipAddressLeaseTime) ? implode(', ', $ipAddressLeaseTime) : var_export($ipAddressLeaseTime, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->ipAddressLeaseTime = $ipAddressLeaseTime;
        return $this;
    }
    /**
     * Get renewalTime value
     * @return string|null
     */
    public function getRenewalTime()
    {
        return $this->renewalTime;
    }
    /**
     * Set renewalTime value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $renewalTime
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDhcpServer
     */
    public function setRenewalTime($renewalTime = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($renewalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($renewalTime) ? implode(', ', $renewalTime) : var_export($renewalTime, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->renewalTime = $renewalTime;
        return $this;
    }
    /**
     * Get rebindingTime value
     * @return string|null
     */
    public function getRebindingTime()
    {
        return $this->rebindingTime;
    }
    /**
     * Set rebindingTime value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rebindingTime
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDhcpServer
     */
    public function setRebindingTime($rebindingTime = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($rebindingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($rebindingTime) ? implode(', ', $rebindingTime) : var_export($rebindingTime, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->rebindingTime = $rebindingTime;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDhcpServer
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
