<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCertificateRole StructType
 * @subpackage Structs
 */
class LCertificateRole extends AbstractStructBase
{
    /**
     * The roleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $roleName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCertificateRole
     * @uses LCertificateRole::setRoleName()
     * @uses LCertificateRole::setUuid()
     * @param string $roleName
     * @param string $uuid
     */
    public function __construct($roleName = null, $uuid = null)
    {
        $this
            ->setRoleName($roleName)
            ->setUuid($uuid);
    }
    /**
     * Get roleName value
     * @return string|null
     */
    public function getRoleName()
    {
        return $this->roleName;
    }
    /**
     * Set roleName value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrustRole::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTrustRole::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roleName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCertificateRole
     */
    public function setRoleName($roleName = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTrustRole::valueIsValid($roleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTrustRole', is_array($roleName) ? implode(', ', $roleName) : var_export($roleName, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTrustRole::getValidValues())), __LINE__);
        }
        $this->roleName = $roleName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCertificateRole
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
