<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LButton StructType
 * @subpackage Structs
 */
class LButton extends AbstractStructBase
{
    /**
     * The feature
     * Meta information extracted from the WSDL
     * - documentation: The feature invoked by this button.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $feature;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - documentation: The label invoked by this button.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The buttonNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $buttonNumber;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LButton
     * @uses LButton::setFeature()
     * @uses LButton::setLabel()
     * @uses LButton::setButtonNumber()
     * @uses LButton::setUuid()
     * @param string $feature
     * @param string $label
     * @param string $buttonNumber
     * @param string $uuid
     */
    public function __construct($feature = null, $label = null, $buttonNumber = null, $uuid = null)
    {
        $this
            ->setFeature($feature)
            ->setLabel($label)
            ->setButtonNumber($buttonNumber)
            ->setUuid($uuid);
    }
    /**
     * Get feature value
     * @return string|null
     */
    public function getFeature()
    {
        return $this->feature;
    }
    /**
     * Set feature value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XFeature::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XFeature::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $feature
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LButton
     */
    public function setFeature($feature = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XFeature::valueIsValid($feature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XFeature', is_array($feature) ? implode(', ', $feature) : var_export($feature, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XFeature::getValidValues())), __LINE__);
        }
        $this->feature = $feature;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LButton
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($label) && mb_strlen($label) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get buttonNumber value
     * @return string|null
     */
    public function getButtonNumber()
    {
        return $this->buttonNumber;
    }
    /**
     * Set buttonNumber value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $buttonNumber
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LButton
     */
    public function setButtonNumber($buttonNumber = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($buttonNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($buttonNumber) ? implode(', ', $buttonNumber) : var_export($buttonNumber, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->buttonNumber = $buttonNumber;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LButton
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
