<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LAssignedPresenceUsers StructType
 * @subpackage Structs
 */
class LAssignedPresenceUsers extends AbstractStructBase
{
    /**
     * The userid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * The server
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $server;
    /**
     * The presenceRedundancyGroup
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $presenceRedundancyGroup;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LAssignedPresenceUsers
     * @uses LAssignedPresenceUsers::setUserid()
     * @uses LAssignedPresenceUsers::setServer()
     * @uses LAssignedPresenceUsers::setPresenceRedundancyGroup()
     * @uses LAssignedPresenceUsers::setUuid()
     * @param string $userid
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $server
     * @param string $presenceRedundancyGroup
     * @param string $uuid
     */
    public function __construct($userid = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $server = null, $presenceRedundancyGroup = null, $uuid = null)
    {
        $this
            ->setUserid($userid)
            ->setServer($server)
            ->setPresenceRedundancyGroup($presenceRedundancyGroup)
            ->setUuid($uuid);
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LAssignedPresenceUsers
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userid, true), gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get server value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getServer()
    {
        return $this->server;
    }
    /**
     * Set server value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $server
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LAssignedPresenceUsers
     */
    public function setServer(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $server = null)
    {
        $this->server = $server;
        return $this;
    }
    /**
     * Get presenceRedundancyGroup value
     * @return string|null
     */
    public function getPresenceRedundancyGroup()
    {
        return $this->presenceRedundancyGroup;
    }
    /**
     * Set presenceRedundancyGroup value
     * @param string $presenceRedundancyGroup
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LAssignedPresenceUsers
     */
    public function setPresenceRedundancyGroup($presenceRedundancyGroup = null)
    {
        // validation for constraint: string
        if (!is_null($presenceRedundancyGroup) && !is_string($presenceRedundancyGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presenceRedundancyGroup, true), gettype($presenceRedundancyGroup)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($presenceRedundancyGroup) && mb_strlen($presenceRedundancyGroup) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($presenceRedundancyGroup)), __LINE__);
        }
        $this->presenceRedundancyGroup = $presenceRedundancyGroup;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LAssignedPresenceUsers
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
