<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LAccessControlGroupName StructType
 * @subpackage Structs
 */
class LAccessControlGroupName extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $name;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LAccessControlGroupName
     * @uses LAccessControlGroupName::setName()
     * @uses LAccessControlGroupName::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $name
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $name = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LAccessControlGroupName
     */
    public function setName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LAccessControlGroupName
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
