<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LAarGroupRelationship StructType
 * @subpackage Structs
 */
class LAarGroupRelationship extends AbstractStructBase
{
    /**
     * The aarGroupFromName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarGroupFromName;
    /**
     * The aarGroupToName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarGroupToName;
    /**
     * The prefixDigit
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefixDigit;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LAarGroupRelationship
     * @uses LAarGroupRelationship::setAarGroupFromName()
     * @uses LAarGroupRelationship::setAarGroupToName()
     * @uses LAarGroupRelationship::setPrefixDigit()
     * @uses LAarGroupRelationship::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroupFromName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroupToName
     * @param string $prefixDigit
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroupFromName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroupToName = null, $prefixDigit = null, $uuid = null)
    {
        $this
            ->setAarGroupFromName($aarGroupFromName)
            ->setAarGroupToName($aarGroupToName)
            ->setPrefixDigit($prefixDigit)
            ->setUuid($uuid);
    }
    /**
     * Get aarGroupFromName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarGroupFromName()
    {
        return $this->aarGroupFromName;
    }
    /**
     * Set aarGroupFromName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroupFromName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LAarGroupRelationship
     */
    public function setAarGroupFromName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroupFromName = null)
    {
        $this->aarGroupFromName = $aarGroupFromName;
        return $this;
    }
    /**
     * Get aarGroupToName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarGroupToName()
    {
        return $this->aarGroupToName;
    }
    /**
     * Set aarGroupToName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroupToName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LAarGroupRelationship
     */
    public function setAarGroupToName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroupToName = null)
    {
        $this->aarGroupToName = $aarGroupToName;
        return $this;
    }
    /**
     * Get prefixDigit value
     * @return string|null
     */
    public function getPrefixDigit()
    {
        return $this->prefixDigit;
    }
    /**
     * Set prefixDigit value
     * @param string $prefixDigit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LAarGroupRelationship
     */
    public function setPrefixDigit($prefixDigit = null)
    {
        // validation for constraint: string
        if (!is_null($prefixDigit) && !is_string($prefixDigit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefixDigit, true), gettype($prefixDigit)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($prefixDigit) && mb_strlen($prefixDigit) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($prefixDigit)), __LINE__);
        }
        $this->prefixDigit = $prefixDigit;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LAarGroupRelationship
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
