<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoiceMailPilotReq StructType
 * @subpackage Structs
 */
class GetVoiceMailPilotReq extends AbstractStructBase
{
    /**
     * The dirn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | dirn | cssName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $dirn;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | dirn | cssName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The cssName
     * Meta information extracted from the WSDL
     * - choice: uuid | dirn | cssName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cssName;
    /**
     * The returnedTags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPilot
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetVoiceMailPilotReq
     * @uses GetVoiceMailPilotReq::setDirn()
     * @uses GetVoiceMailPilotReq::setUuid()
     * @uses GetVoiceMailPilotReq::setCssName()
     * @uses GetVoiceMailPilotReq::setReturnedTags()
     * @uses GetVoiceMailPilotReq::setSequence()
     * @param string $dirn
     * @param string $uuid
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cssName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPilot $returnedTags
     * @param int $sequence
     */
    public function __construct($dirn = null, $uuid = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cssName = null, \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPilot $returnedTags = null, $sequence = null)
    {
        $this
            ->setDirn($dirn)
            ->setUuid($uuid)
            ->setCssName($cssName)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get dirn value
     * @return string
     */
    public function getDirn()
    {
        return isset($this->dirn) ? $this->dirn : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDirn method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDirn method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDirnForChoiceConstraintsFromSetDirn($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'cssName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property dirn can\'t be set as the property %s is already set. Only one property must be set among these properties: dirn, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set dirn value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $dirn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetVoiceMailPilotReq
     */
    public function setDirn($dirn = null)
    {
        // validation for constraint: string
        if (!is_null($dirn) && !is_string($dirn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dirn, true), gettype($dirn)), __LINE__);
        }
        // validation for constraint: choice(uuid, dirn, cssName)
        if ('' !== ($dirnChoiceErrorMessage = self::validateDirnForChoiceConstraintsFromSetDirn($dirn))) {
            throw new \InvalidArgumentException($dirnChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($dirn) && mb_strlen($dirn) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($dirn)), __LINE__);
        }
        if (is_null($dirn) || (is_array($dirn) && empty($dirn))) {
            unset($this->dirn);
        } else {
            $this->dirn = $dirn;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'dirn',
            'cssName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetVoiceMailPilotReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, dirn, cssName)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get cssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCssName()
    {
        return isset($this->cssName) ? $this->cssName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCssName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCssName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCssNameForChoiceConstraintsFromSetCssName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'dirn',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property cssName can\'t be set as the property %s is already set. Only one property must be set among these properties: cssName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set cssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetVoiceMailPilotReq
     */
    public function setCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cssName = null)
    {
        // validation for constraint: choice(uuid, dirn, cssName)
        if ('' !== ($cssNameChoiceErrorMessage = self::validateCssNameForChoiceConstraintsFromSetCssName($cssName))) {
            throw new \InvalidArgumentException($cssNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($cssName) || (is_array($cssName) && empty($cssName))) {
            unset($this->cssName);
        } else {
            $this->cssName = $cssName;
        }
        return $this;
    }
    /**
     * Get returnedTags value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPilot|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPilot $returnedTags
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetVoiceMailPilotReq
     */
    public function setReturnedTags(\Losc\CucmBundle\Model\Webservice\StructType\RVoiceMailPilot $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetVoiceMailPilotReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !(is_int($sequence) || ctype_digit($sequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequence, true), gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
}
