<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSNMPMIB2ListReq StructType
 * @subpackage Structs
 */
class GetSNMPMIB2ListReq extends APIRequest
{
    /**
     * The sysContact
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * @var string
     */
    public $sysContact;
    /**
     * Constructor method for GetSNMPMIB2ListReq
     * @uses GetSNMPMIB2ListReq::setSysContact()
     * @param string $sysContact
     */
    public function __construct($sysContact = null)
    {
        $this
            ->setSysContact($sysContact);
    }
    /**
     * Get sysContact value
     * @return string|null
     */
    public function getSysContact()
    {
        return $this->sysContact;
    }
    /**
     * Set sysContact value
     * @param string $sysContact
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetSNMPMIB2ListReq
     */
    public function setSysContact($sysContact = null)
    {
        // validation for constraint: string
        if (!is_null($sysContact) && !is_string($sysContact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sysContact, true), gettype($sysContact)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($sysContact) && mb_strlen($sysContact) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($sysContact)), __LINE__);
        }
        $this->sysContact = $sysContact;
        return $this;
    }
}
