<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPhoneTypeDisplayInstanceRes StructType
 * @subpackage Structs
 */
class GetPhoneTypeDisplayInstanceRes extends APIResponse
{
    /**
     * The displayInstance
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * @var string
     */
    public $displayInstance;
    /**
     * Constructor method for GetPhoneTypeDisplayInstanceRes
     * @uses GetPhoneTypeDisplayInstanceRes::setDisplayInstance()
     * @param string $displayInstance
     */
    public function __construct($displayInstance = null)
    {
        $this
            ->setDisplayInstance($displayInstance);
    }
    /**
     * Get displayInstance value
     * @return string|null
     */
    public function getDisplayInstance()
    {
        return $this->displayInstance;
    }
    /**
     * Set displayInstance value
     * @param string $displayInstance
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetPhoneTypeDisplayInstanceRes
     */
    public function setDisplayInstance($displayInstance = null)
    {
        // validation for constraint: string
        if (!is_null($displayInstance) && !is_string($displayInstance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayInstance, true), gettype($displayInstance)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($displayInstance) && mb_strlen($displayInstance) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($displayInstance)), __LINE__);
        }
        $this->displayInstance = $displayInstance;
        return $this;
    }
}
