<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLdapSyncCustomFieldReq StructType
 * @subpackage Structs
 */
class GetLdapSyncCustomFieldReq extends AbstractStructBase
{
    /**
     * The ldapConfigurationName
     * Meta information extracted from the WSDL
     * - choice: uuid | ldapConfigurationName | customUserField
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ldapConfigurationName;
    /**
     * The customUserField
     * Meta information extracted from the WSDL
     * - choice: uuid | ldapConfigurationName | customUserField
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $customUserField;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | ldapConfigurationName | customUserField
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The returnedTags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\RLdapSyncCustomField
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetLdapSyncCustomFieldReq
     * @uses GetLdapSyncCustomFieldReq::setLdapConfigurationName()
     * @uses GetLdapSyncCustomFieldReq::setCustomUserField()
     * @uses GetLdapSyncCustomFieldReq::setUuid()
     * @uses GetLdapSyncCustomFieldReq::setReturnedTags()
     * @uses GetLdapSyncCustomFieldReq::setSequence()
     * @param string $ldapConfigurationName
     * @param string $customUserField
     * @param string $uuid
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RLdapSyncCustomField $returnedTags
     * @param int $sequence
     */
    public function __construct($ldapConfigurationName = null, $customUserField = null, $uuid = null, \Losc\CucmBundle\Model\Webservice\StructType\RLdapSyncCustomField $returnedTags = null, $sequence = null)
    {
        $this
            ->setLdapConfigurationName($ldapConfigurationName)
            ->setCustomUserField($customUserField)
            ->setUuid($uuid)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get ldapConfigurationName value
     * @return string
     */
    public function getLdapConfigurationName()
    {
        return isset($this->ldapConfigurationName) ? $this->ldapConfigurationName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLdapConfigurationName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLdapConfigurationName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLdapConfigurationNameForChoiceConstraintsFromSetLdapConfigurationName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'customUserField',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ldapConfigurationName can\'t be set as the property %s is already set. Only one property must be set among these properties: ldapConfigurationName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ldapConfigurationName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $ldapConfigurationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetLdapSyncCustomFieldReq
     */
    public function setLdapConfigurationName($ldapConfigurationName = null)
    {
        // validation for constraint: string
        if (!is_null($ldapConfigurationName) && !is_string($ldapConfigurationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ldapConfigurationName, true), gettype($ldapConfigurationName)), __LINE__);
        }
        // validation for constraint: choice(uuid, ldapConfigurationName, customUserField)
        if ('' !== ($ldapConfigurationNameChoiceErrorMessage = self::validateLdapConfigurationNameForChoiceConstraintsFromSetLdapConfigurationName($ldapConfigurationName))) {
            throw new \InvalidArgumentException($ldapConfigurationNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($ldapConfigurationName) || (is_array($ldapConfigurationName) && empty($ldapConfigurationName))) {
            unset($this->ldapConfigurationName);
        } else {
            $this->ldapConfigurationName = $ldapConfigurationName;
        }
        return $this;
    }
    /**
     * Get customUserField value
     * @return string
     */
    public function getCustomUserField()
    {
        return isset($this->customUserField) ? $this->customUserField : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCustomUserField method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomUserField method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCustomUserFieldForChoiceConstraintsFromSetCustomUserField($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'ldapConfigurationName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property customUserField can\'t be set as the property %s is already set. Only one property must be set among these properties: customUserField, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set customUserField value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $customUserField
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetLdapSyncCustomFieldReq
     */
    public function setCustomUserField($customUserField = null)
    {
        // validation for constraint: string
        if (!is_null($customUserField) && !is_string($customUserField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customUserField, true), gettype($customUserField)), __LINE__);
        }
        // validation for constraint: choice(uuid, ldapConfigurationName, customUserField)
        if ('' !== ($customUserFieldChoiceErrorMessage = self::validateCustomUserFieldForChoiceConstraintsFromSetCustomUserField($customUserField))) {
            throw new \InvalidArgumentException($customUserFieldChoiceErrorMessage, __LINE__);
        }
        if (is_null($customUserField) || (is_array($customUserField) && empty($customUserField))) {
            unset($this->customUserField);
        } else {
            $this->customUserField = $customUserField;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ldapConfigurationName',
            'customUserField',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetLdapSyncCustomFieldReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, ldapConfigurationName, customUserField)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get returnedTags value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RLdapSyncCustomField|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RLdapSyncCustomField $returnedTags
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetLdapSyncCustomFieldReq
     */
    public function setReturnedTags(\Losc\CucmBundle\Model\Webservice\StructType\RLdapSyncCustomField $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetLdapSyncCustomFieldReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !(is_int($sequence) || ctype_digit($sequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequence, true), gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
}
