<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDhcpServerReq StructType
 * @subpackage Structs
 */
class GetDhcpServerReq extends AbstractStructBase
{
    /**
     * The processNodeName
     * Meta information extracted from the WSDL
     * - choice: processNodeName | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $processNodeName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: processNodeName | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The returnedTags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\RDhcpServer
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetDhcpServerReq
     * @uses GetDhcpServerReq::setProcessNodeName()
     * @uses GetDhcpServerReq::setUuid()
     * @uses GetDhcpServerReq::setReturnedTags()
     * @uses GetDhcpServerReq::setSequence()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @param string $uuid
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RDhcpServer $returnedTags
     * @param int $sequence
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null, $uuid = null, \Losc\CucmBundle\Model\Webservice\StructType\RDhcpServer $returnedTags = null, $sequence = null)
    {
        $this
            ->setProcessNodeName($processNodeName)
            ->setUuid($uuid)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get processNodeName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getProcessNodeName()
    {
        return isset($this->processNodeName) ? $this->processNodeName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setProcessNodeName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProcessNodeName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateProcessNodeNameForChoiceConstraintsFromSetProcessNodeName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property processNodeName can\'t be set as the property %s is already set. Only one property must be set among these properties: processNodeName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set processNodeName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetDhcpServerReq
     */
    public function setProcessNodeName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null)
    {
        // validation for constraint: choice(processNodeName, uuid)
        if ('' !== ($processNodeNameChoiceErrorMessage = self::validateProcessNodeNameForChoiceConstraintsFromSetProcessNodeName($processNodeName))) {
            throw new \InvalidArgumentException($processNodeNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($processNodeName) || (is_array($processNodeName) && empty($processNodeName))) {
            unset($this->processNodeName);
        } else {
            $this->processNodeName = $processNodeName;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'processNodeName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetDhcpServerReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(processNodeName, uuid)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get returnedTags value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RDhcpServer|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RDhcpServer $returnedTags
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetDhcpServerReq
     */
    public function setReturnedTags(\Losc\CucmBundle\Model\Webservice\StructType\RDhcpServer $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetDhcpServerReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !(is_int($sequence) || ctype_digit($sequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequence, true), gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
}
