<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCCMVersionReq StructType
 * @subpackage Structs
 */
class GetCCMVersionReq extends AbstractStructBase
{
    /**
     * The processNodeName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - minOccurs: 0
     * @var string
     */
    public $processNodeName;
    /**
     * Constructor method for GetCCMVersionReq
     * @uses GetCCMVersionReq::setProcessNodeName()
     * @param string $processNodeName
     */
    public function __construct($processNodeName = null)
    {
        $this
            ->setProcessNodeName($processNodeName);
    }
    /**
     * Get processNodeName value
     * @return string|null
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param string $processNodeName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetCCMVersionReq
     */
    public function setProcessNodeName($processNodeName = null)
    {
        // validation for constraint: string
        if (!is_null($processNodeName) && !is_string($processNodeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processNodeName, true), gettype($processNodeName)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($processNodeName) && mb_strlen($processNodeName) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($processNodeName)), __LINE__);
        }
        $this->processNodeName = $processNodeName;
        return $this;
    }
}
