<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoDeviceResetReq StructType
 * Meta information extracted from the WSDL
 * - documentation: Performs either a hard or soft reset on the specified device. If resetting an MGCP box, then set isMGCP attribute to true.
 * @subpackage Structs
 */
class DoDeviceResetReq extends APIRequest
{
    /**
     * The deviceName
     * Meta information extracted from the WSDL
     * - documentation: The name or UUID of the device to performs a reset on. Not nullable.
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $deviceName;
    /**
     * The isHardReset
     * Meta information extracted from the WSDL
     * - documentation: True performs a hard reset. False performs a soft reset. Not nullable.
     * - base: xsd:string
     * - choice: isHardReset | deviceResetType
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isHardReset;
    /**
     * The deviceResetType
     * Meta information extracted from the WSDL
     * - documentation: Not nullable
     * - choice: isHardReset | deviceResetType
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - nillable: false
     * @var string
     */
    public $deviceResetType;
    /**
     * The isMGCP
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * - use: optional
     * @var string
     */
    public $isMGCP;
    /**
     * Constructor method for DoDeviceResetReq
     * @uses DoDeviceResetReq::setDeviceName()
     * @uses DoDeviceResetReq::setIsHardReset()
     * @uses DoDeviceResetReq::setDeviceResetType()
     * @uses DoDeviceResetReq::setIsMGCP()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceName
     * @param string $isHardReset
     * @param string $deviceResetType
     * @param string $isMGCP
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceName = null, $isHardReset = null, $deviceResetType = null, $isMGCP = 'false')
    {
        $this
            ->setDeviceName($deviceName)
            ->setIsHardReset($isHardReset)
            ->setDeviceResetType($deviceResetType)
            ->setIsMGCP($isMGCP);
    }
    /**
     * Get deviceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDeviceName()
    {
        return $this->deviceName;
    }
    /**
     * Set deviceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\DoDeviceResetReq
     */
    public function setDeviceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceName = null)
    {
        $this->deviceName = $deviceName;
        return $this;
    }
    /**
     * Get isHardReset value
     * @return string|null
     */
    public function getIsHardReset()
    {
        return isset($this->isHardReset) ? $this->isHardReset : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIsHardReset method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsHardReset method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIsHardResetForChoiceConstraintsFromSetIsHardReset($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'deviceResetType',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property isHardReset can\'t be set as the property %s is already set. Only one property must be set among these properties: isHardReset, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set isHardReset value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $isHardReset
     * @return \Losc\CucmBundle\Model\Webservice\StructType\DoDeviceResetReq
     */
    public function setIsHardReset($isHardReset = null)
    {
        // validation for constraint: string
        if (!is_null($isHardReset) && !is_string($isHardReset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isHardReset, true), gettype($isHardReset)), __LINE__);
        }
        // validation for constraint: choice(isHardReset, deviceResetType)
        if ('' !== ($isHardResetChoiceErrorMessage = self::validateIsHardResetForChoiceConstraintsFromSetIsHardReset($isHardReset))) {
            throw new \InvalidArgumentException($isHardResetChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isHardReset) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isHardReset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isHardReset, true)), __LINE__);
        }
        if (is_null($isHardReset) || (is_array($isHardReset) && empty($isHardReset))) {
            unset($this->isHardReset);
        } else {
            $this->isHardReset = $isHardReset;
        }
        return $this;
    }
    /**
     * Get deviceResetType value
     * @return string|null
     */
    public function getDeviceResetType()
    {
        return isset($this->deviceResetType) ? $this->deviceResetType : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDeviceResetType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeviceResetType method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDeviceResetTypeForChoiceConstraintsFromSetDeviceResetType($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'isHardReset',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property deviceResetType can\'t be set as the property %s is already set. Only one property must be set among these properties: deviceResetType, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set deviceResetType value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XReset::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XReset::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceResetType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\DoDeviceResetReq
     */
    public function setDeviceResetType($deviceResetType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XReset::valueIsValid($deviceResetType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XReset', is_array($deviceResetType) ? implode(', ', $deviceResetType) : var_export($deviceResetType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XReset::getValidValues())), __LINE__);
        }
        // validation for constraint: choice(isHardReset, deviceResetType)
        if ('' !== ($deviceResetTypeChoiceErrorMessage = self::validateDeviceResetTypeForChoiceConstraintsFromSetDeviceResetType($deviceResetType))) {
            throw new \InvalidArgumentException($deviceResetTypeChoiceErrorMessage, __LINE__);
        }
        if (is_null($deviceResetType) || (is_array($deviceResetType) && empty($deviceResetType))) {
            unset($this->deviceResetType);
        } else {
            $this->deviceResetType = $deviceResetType;
        }
        return $this;
    }
    /**
     * Get isMGCP value
     * @return string|null
     */
    public function getIsMGCP()
    {
        return $this->isMGCP;
    }
    /**
     * Set isMGCP value
     * @param string $isMGCP
     * @return \Losc\CucmBundle\Model\Webservice\StructType\DoDeviceResetReq
     */
    public function setIsMGCP($isMGCP = 'false')
    {
        // validation for constraint: string
        if (!is_null($isMGCP) && !is_string($isMGCP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isMGCP, true), gettype($isMGCP)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isMGCP) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isMGCP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isMGCP, true)), __LINE__);
        }
        $this->isMGCP = $isMGCP;
        return $this;
    }
}
