<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for directoryURIs StructType
 * Meta information extracted from the WSDL
 * - documentation: While updating, send all the URIs
 * @subpackage Structs
 */
class DirectoryURIs extends AbstractStructBase
{
    /**
     * The directoryUri
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XDirectoryUri[]
     */
    public $directoryUri;
    /**
     * Constructor method for directoryURIs
     * @uses DirectoryURIs::setDirectoryUri()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XDirectoryUri[] $directoryUri
     */
    public function __construct(array $directoryUri = array())
    {
        $this
            ->setDirectoryUri($directoryUri);
    }
    /**
     * Get directoryUri value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XDirectoryUri[]|null
     */
    public function getDirectoryUri()
    {
        return $this->directoryUri;
    }
    /**
     * This method is responsible for validating the values passed to the setDirectoryUri method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDirectoryUri method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDirectoryUriForArrayConstraintsFromSetDirectoryUri(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $directoryURIsDirectoryUriItem) {
            // validation for constraint: itemType
            if (!$directoryURIsDirectoryUriItem instanceof \Losc\CucmBundle\Model\Webservice\StructType\XDirectoryUri) {
                $invalidValues[] = is_object($directoryURIsDirectoryUriItem) ? get_class($directoryURIsDirectoryUriItem) : sprintf('%s(%s)', gettype($directoryURIsDirectoryUriItem), var_export($directoryURIsDirectoryUriItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The directoryUri property can only contain items of type \Losc\CucmBundle\Model\Webservice\StructType\XDirectoryUri, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set directoryUri value
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XDirectoryUri[] $directoryUri
     * @return \Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs
     */
    public function setDirectoryUri(array $directoryUri = array())
    {
        // validation for constraint: array
        if ('' !== ($directoryUriArrayErrorMessage = self::validateDirectoryUriForArrayConstraintsFromSetDirectoryUri($directoryUri))) {
            throw new \InvalidArgumentException($directoryUriArrayErrorMessage, __LINE__);
        }
        $this->directoryUri = $directoryUri;
        return $this;
    }
    /**
     * Add item to directoryUri value
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XDirectoryUri $item
     * @return \Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs
     */
    public function addToDirectoryUri(\Losc\CucmBundle\Model\Webservice\StructType\XDirectoryUri $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Losc\CucmBundle\Model\Webservice\StructType\XDirectoryUri) {
            throw new \InvalidArgumentException(sprintf('The directoryUri property can only contain items of type \Losc\CucmBundle\Model\Webservice\StructType\XDirectoryUri, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->directoryUri[] = $item;
        return $this;
    }
}
