<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for destinations StructType
 * @subpackage Structs
 */
class Destinations extends XCommonMembersExtension
{
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - maxOccurs: 16
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XH323TrunkDestination[]
     */
    public $destination;
    /**
     * Constructor method for destinations
     * @uses Destinations::setDestination()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XH323TrunkDestination[] $destination
     */
    public function __construct(array $destination = array())
    {
        $this
            ->setDestination($destination);
    }
    /**
     * Get destination value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XH323TrunkDestination[]|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * This method is responsible for validating the values passed to the setDestination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDestination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDestinationForArrayConstraintsFromSetDestination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $destinationsDestinationItem) {
            // validation for constraint: itemType
            if (!$destinationsDestinationItem instanceof \Losc\CucmBundle\Model\Webservice\StructType\XH323TrunkDestination) {
                $invalidValues[] = is_object($destinationsDestinationItem) ? get_class($destinationsDestinationItem) : sprintf('%s(%s)', gettype($destinationsDestinationItem), var_export($destinationsDestinationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The destination property can only contain items of type \Losc\CucmBundle\Model\Webservice\StructType\XH323TrunkDestination, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set destination value
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XH323TrunkDestination[] $destination
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Destinations
     */
    public function setDestination(array $destination = array())
    {
        // validation for constraint: array
        if ('' !== ($destinationArrayErrorMessage = self::validateDestinationForArrayConstraintsFromSetDestination($destination))) {
            throw new \InvalidArgumentException($destinationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(16)
        if (is_array($destination) && count($destination) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 16', count($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Add item to destination value
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XH323TrunkDestination $item
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Destinations
     */
    public function addToDestination(\Losc\CucmBundle\Model\Webservice\StructType\XH323TrunkDestination $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Losc\CucmBundle\Model\Webservice\StructType\XH323TrunkDestination) {
            throw new \InvalidArgumentException(sprintf('The destination property can only contain items of type \Losc\CucmBundle\Model\Webservice\StructType\XH323TrunkDestination, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(16)
        if (is_array($this->destination) && count($this->destination) >= 16) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 16', count($this->destination)), __LINE__);
        }
        $this->destination[] = $item;
        return $this;
    }
}
