<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for associatedTodAccess StructType
 * Meta information extracted from the WSDL
 * - documentation: Read-Only. List of the todAccess entries associated with this EndUser.
 * @subpackage Structs
 */
class AssociatedTodAccess extends AbstractStructBase
{
    /**
     * The todAccess
     * Meta information extracted from the WSDL
     * - documentation: Name of the todAccess.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $todAccess;
    /**
     * Constructor method for associatedTodAccess
     * @uses AssociatedTodAccess::setTodAccess()
     * @param string[] $todAccess
     */
    public function __construct(array $todAccess = array())
    {
        $this
            ->setTodAccess($todAccess);
    }
    /**
     * Get todAccess value
     * @return string[]|null
     */
    public function getTodAccess()
    {
        return $this->todAccess;
    }
    /**
     * This method is responsible for validating the values passed to the setTodAccess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTodAccess method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTodAccessForArrayConstraintsFromSetTodAccess(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associatedTodAccessTodAccessItem) {
            // validation for constraint: itemType
            if (!is_string($associatedTodAccessTodAccessItem)) {
                $invalidValues[] = is_object($associatedTodAccessTodAccessItem) ? get_class($associatedTodAccessTodAccessItem) : sprintf('%s(%s)', gettype($associatedTodAccessTodAccessItem), var_export($associatedTodAccessTodAccessItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The todAccess property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set todAccess value
     * @throws \InvalidArgumentException
     * @param string[] $todAccess
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedTodAccess
     */
    public function setTodAccess(array $todAccess = array())
    {
        // validation for constraint: array
        if ('' !== ($todAccessArrayErrorMessage = self::validateTodAccessForArrayConstraintsFromSetTodAccess($todAccess))) {
            throw new \InvalidArgumentException($todAccessArrayErrorMessage, __LINE__);
        }
        $this->todAccess = $todAccess;
        return $this;
    }
    /**
     * Add item to todAccess value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedTodAccess
     */
    public function addToTodAccess($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The todAccess property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->todAccess[] = $item;
        return $this;
    }
}
