<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for associatedRemoteDestinationProfiles StructType
 * Meta information extracted from the WSDL
 * - documentation: Read-Only.These groups automatically get added once the user is associated with a Remote Destination Profile.
 * @subpackage Structs
 */
class AssociatedRemoteDestinationProfiles extends AbstractStructBase
{
    /**
     * The remoteDestinationProfile
     * Meta information extracted from the WSDL
     * - documentation: Name of the remoteDestinationProfile
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $remoteDestinationProfile;
    /**
     * Constructor method for associatedRemoteDestinationProfiles
     * @uses AssociatedRemoteDestinationProfiles::setRemoteDestinationProfile()
     * @param string[] $remoteDestinationProfile
     */
    public function __construct(array $remoteDestinationProfile = array())
    {
        $this
            ->setRemoteDestinationProfile($remoteDestinationProfile);
    }
    /**
     * Get remoteDestinationProfile value
     * @return string[]|null
     */
    public function getRemoteDestinationProfile()
    {
        return $this->remoteDestinationProfile;
    }
    /**
     * This method is responsible for validating the values passed to the setRemoteDestinationProfile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemoteDestinationProfile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemoteDestinationProfileForArrayConstraintsFromSetRemoteDestinationProfile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associatedRemoteDestinationProfilesRemoteDestinationProfileItem) {
            // validation for constraint: itemType
            if (!is_string($associatedRemoteDestinationProfilesRemoteDestinationProfileItem)) {
                $invalidValues[] = is_object($associatedRemoteDestinationProfilesRemoteDestinationProfileItem) ? get_class($associatedRemoteDestinationProfilesRemoteDestinationProfileItem) : sprintf('%s(%s)', gettype($associatedRemoteDestinationProfilesRemoteDestinationProfileItem), var_export($associatedRemoteDestinationProfilesRemoteDestinationProfileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The remoteDestinationProfile property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set remoteDestinationProfile value
     * @throws \InvalidArgumentException
     * @param string[] $remoteDestinationProfile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedRemoteDestinationProfiles
     */
    public function setRemoteDestinationProfile(array $remoteDestinationProfile = array())
    {
        // validation for constraint: array
        if ('' !== ($remoteDestinationProfileArrayErrorMessage = self::validateRemoteDestinationProfileForArrayConstraintsFromSetRemoteDestinationProfile($remoteDestinationProfile))) {
            throw new \InvalidArgumentException($remoteDestinationProfileArrayErrorMessage, __LINE__);
        }
        $this->remoteDestinationProfile = $remoteDestinationProfile;
        return $this;
    }
    /**
     * Add item to remoteDestinationProfile value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedRemoteDestinationProfiles
     */
    public function addToRemoteDestinationProfile($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The remoteDestinationProfile property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->remoteDestinationProfile[] = $item;
        return $this;
    }
}
