<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for associatedRemoteDestination StructType
 * Meta information extracted from the WSDL
 * - documentation: Read-Only. List of the remoteDestination entries associated with this TodAccess.
 * @subpackage Structs
 */
class AssociatedRemoteDestination extends AbstractStructBase
{
    /**
     * The remoteDestination
     * Meta information extracted from the WSDL
     * - documentation: Name of the remoteDestination
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $remoteDestination;
    /**
     * Constructor method for associatedRemoteDestination
     * @uses AssociatedRemoteDestination::setRemoteDestination()
     * @param string[] $remoteDestination
     */
    public function __construct(array $remoteDestination = array())
    {
        $this
            ->setRemoteDestination($remoteDestination);
    }
    /**
     * Get remoteDestination value
     * @return string[]|null
     */
    public function getRemoteDestination()
    {
        return $this->remoteDestination;
    }
    /**
     * This method is responsible for validating the values passed to the setRemoteDestination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemoteDestination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemoteDestinationForArrayConstraintsFromSetRemoteDestination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associatedRemoteDestinationRemoteDestinationItem) {
            // validation for constraint: itemType
            if (!is_string($associatedRemoteDestinationRemoteDestinationItem)) {
                $invalidValues[] = is_object($associatedRemoteDestinationRemoteDestinationItem) ? get_class($associatedRemoteDestinationRemoteDestinationItem) : sprintf('%s(%s)', gettype($associatedRemoteDestinationRemoteDestinationItem), var_export($associatedRemoteDestinationRemoteDestinationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The remoteDestination property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set remoteDestination value
     * @throws \InvalidArgumentException
     * @param string[] $remoteDestination
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedRemoteDestination
     */
    public function setRemoteDestination(array $remoteDestination = array())
    {
        // validation for constraint: array
        if ('' !== ($remoteDestinationArrayErrorMessage = self::validateRemoteDestinationForArrayConstraintsFromSetRemoteDestination($remoteDestination))) {
            throw new \InvalidArgumentException($remoteDestinationArrayErrorMessage, __LINE__);
        }
        $this->remoteDestination = $remoteDestination;
        return $this;
    }
    /**
     * Add item to remoteDestination value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedRemoteDestination
     */
    public function addToRemoteDestination($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The remoteDestination property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->remoteDestination[] = $item;
        return $this;
    }
}
