<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addresses StructType
 * Meta information extracted from the WSDL
 * - documentation: Valid only for Cisco TelePresence Conference bridges
 * @subpackage Structs
 */
class Addresses extends AbstractStructBase
{
    /**
     * The address
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var string[]
     */
    public $address;
    /**
     * Constructor method for addresses
     * @uses Addresses::setAddress()
     * @param string[] $address
     */
    public function __construct(array $address = array())
    {
        $this
            ->setAddress($address);
    }
    /**
     * Get address value
     * @return string[]|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressesAddressItem) {
            // validation for constraint: itemType
            if (!is_string($addressesAddressItem)) {
                $invalidValues[] = is_object($addressesAddressItem) ? get_class($addressesAddressItem) : sprintf('%s(%s)', gettype($addressesAddressItem), var_export($addressesAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The address property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set address value
     * @throws \InvalidArgumentException
     * @param string[] $address
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Addresses
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($address) && count($address) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Add item to address value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Addresses
     */
    public function addToAddress($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The address property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->address) && count($this->address) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->address)), __LINE__);
        }
        $this->address[] = $item;
        return $this;
    }
}
