<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AXLError StructType
 * @subpackage Structs
 */
class AXLError extends AbstractStructBase
{
    /**
     * The axlcode
     * @var int
     */
    public $axlcode;
    /**
     * The axlmessage
     * @var string
     */
    public $axlmessage;
    /**
     * The request
     * @var string
     */
    public $request;
    /**
     * Constructor method for AXLError
     * @uses AXLError::setAxlcode()
     * @uses AXLError::setAxlmessage()
     * @uses AXLError::setRequest()
     * @param int $axlcode
     * @param string $axlmessage
     * @param string $request
     */
    public function __construct($axlcode = null, $axlmessage = null, $request = null)
    {
        $this
            ->setAxlcode($axlcode)
            ->setAxlmessage($axlmessage)
            ->setRequest($request);
    }
    /**
     * Get axlcode value
     * @return int|null
     */
    public function getAxlcode()
    {
        return $this->axlcode;
    }
    /**
     * Set axlcode value
     * @param int $axlcode
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AXLError
     */
    public function setAxlcode($axlcode = null)
    {
        // validation for constraint: int
        if (!is_null($axlcode) && !(is_int($axlcode) || ctype_digit($axlcode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($axlcode, true), gettype($axlcode)), __LINE__);
        }
        $this->axlcode = $axlcode;
        return $this;
    }
    /**
     * Get axlmessage value
     * @return string|null
     */
    public function getAxlmessage()
    {
        return $this->axlmessage;
    }
    /**
     * Set axlmessage value
     * @param string $axlmessage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AXLError
     */
    public function setAxlmessage($axlmessage = null)
    {
        // validation for constraint: string
        if (!is_null($axlmessage) && !is_string($axlmessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axlmessage, true), gettype($axlmessage)), __LINE__);
        }
        $this->axlmessage = $axlmessage;
        return $this;
    }
    /**
     * Get request value
     * @return string|null
     */
    public function getRequest()
    {
        return $this->request;
    }
    /**
     * Set request value
     * @param string $request
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AXLError
     */
    public function setRequest($request = null)
    {
        // validation for constraint: string
        if (!is_null($request) && !is_string($request)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($request, true), gettype($request)), __LINE__);
        }
        $this->request = $request;
        return $this;
    }
}
