<?php

namespace Losc\CucmBundle\Model\Webservice\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lock ServiceType
 * @subpackage Services
 */
class Lock extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named lockPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function lockPhone(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->lockPhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
