<?php

namespace Losc\CucmBundle\Model\Webservice\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Execute ServiceType
 * @subpackage Services
 */
class Execute extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named executeSQLQuery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ExecuteSQLQueryReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ExecuteSQLQueryRes|bool
     */
    public function executeSQLQuery(\Losc\CucmBundle\Model\Webservice\StructType\ExecuteSQLQueryReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->executeSQLQuery($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named executeSQLUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ExecuteSQLUpdateReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ExecuteSQLUpdateRes|bool
     */
    public function executeSQLUpdate(\Losc\CucmBundle\Model\Webservice\StructType\ExecuteSQLUpdateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->executeSQLUpdate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ExecuteSQLQueryRes|\Losc\CucmBundle\Model\Webservice\StructType\ExecuteSQLUpdateRes
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
