<?php

namespace Losc\CucmBundle\Model\Webservice\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addSipProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddSipProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addSipProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddSipProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addSipProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSipTrunkSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddSipTrunkSecurityProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addSipTrunkSecurityProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddSipTrunkSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addSipTrunkSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTimePeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddTimePeriodReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addTimePeriod(\Losc\CucmBundle\Model\Webservice\StructType\AddTimePeriodReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addTimePeriod($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTimeSchedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddTimeScheduleReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addTimeSchedule(\Losc\CucmBundle\Model\Webservice\StructType\AddTimeScheduleReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addTimeSchedule($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTodAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddTodAccessReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addTodAccess(\Losc\CucmBundle\Model\Webservice\StructType\AddTodAccessReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addTodAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVoiceMailPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddVoiceMailPilotReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addVoiceMailPilot(\Losc\CucmBundle\Model\Webservice\StructType\AddVoiceMailPilotReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addVoiceMailPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addProcessNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddProcessNodeReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addProcessNode(\Losc\CucmBundle\Model\Webservice\StructType\AddProcessNodeReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addProcessNode($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCallerFilterList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCallerFilterListReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCallerFilterList(\Losc\CucmBundle\Model\Webservice\StructType\AddCallerFilterListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCallerFilterList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRoutePartition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddRoutePartitionReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addRoutePartition(\Losc\CucmBundle\Model\Webservice\StructType\AddRoutePartitionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addRoutePartition($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCssReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCss(\Losc\CucmBundle\Model\Webservice\StructType\AddCssReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCss($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMediaResourceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddMediaResourceGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addMediaResourceGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddMediaResourceGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addMediaResourceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMediaResourceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddMediaResourceListReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addMediaResourceList(\Losc\CucmBundle\Model\Webservice\StructType\AddMediaResourceListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addMediaResourceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddRegionReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addRegion(\Losc\CucmBundle\Model\Webservice\StructType\AddRegionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addRegion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addAarGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddAarGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addAarGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddAarGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addAarGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPhysicalLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddPhysicalLocationReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addPhysicalLocation(\Losc\CucmBundle\Model\Webservice\StructType\AddPhysicalLocationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addPhysicalLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddRouteGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addRouteGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddRouteGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDevicePool
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddDevicePoolReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addDevicePool(\Losc\CucmBundle\Model\Webservice\StructType\AddDevicePoolReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addDevicePool($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDeviceMobilityGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddDeviceMobilityGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addDeviceMobilityGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddDeviceMobilityGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addDeviceMobilityGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddLocationReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addLocation(\Losc\CucmBundle\Model\Webservice\StructType\AddLocationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSoftKeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddSoftKeyTemplateReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addSoftKeyTemplate(\Losc\CucmBundle\Model\Webservice\StructType\AddSoftKeyTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addSoftKeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTranscoder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddTranscoderReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addTranscoder(\Losc\CucmBundle\Model\Webservice\StructType\AddTranscoderReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addTranscoder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCommonDeviceConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCommonDeviceConfigReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCommonDeviceConfig(\Losc\CucmBundle\Model\Webservice\StructType\AddCommonDeviceConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCommonDeviceConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addResourcePriorityNamespace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddResourcePriorityNamespaceReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addResourcePriorityNamespace(\Losc\CucmBundle\Model\Webservice\StructType\AddResourcePriorityNamespaceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addResourcePriorityNamespace($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addResourcePriorityNamespaceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddResourcePriorityNamespaceListReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addResourcePriorityNamespaceList(\Losc\CucmBundle\Model\Webservice\StructType\AddResourcePriorityNamespaceListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addResourcePriorityNamespaceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDeviceMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddDeviceMobilityReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addDeviceMobility(\Losc\CucmBundle\Model\Webservice\StructType\AddDeviceMobilityReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addDeviceMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCmcInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCmcInfoReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCmcInfo(\Losc\CucmBundle\Model\Webservice\StructType\AddCmcInfoReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCmcInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCredentialPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCredentialPolicyReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCredentialPolicy(\Losc\CucmBundle\Model\Webservice\StructType\AddCredentialPolicyReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCredentialPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addFacInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddFacInfoReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addFacInfo(\Losc\CucmBundle\Model\Webservice\StructType\AddFacInfoReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addFacInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addHuntList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddHuntListReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addHuntList(\Losc\CucmBundle\Model\Webservice\StructType\AddHuntListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addHuntList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addIvrUserLocale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddIvrUserLocaleReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addIvrUserLocale(\Losc\CucmBundle\Model\Webservice\StructType\AddIvrUserLocaleReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addIvrUserLocale($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLineGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddLineGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addLineGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddLineGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addLineGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRecordingProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddRecordingProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addRecordingProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddRecordingProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addRecordingProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRouteFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddRouteFilterReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addRouteFilter(\Losc\CucmBundle\Model\Webservice\StructType\AddRouteFilterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addRouteFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCallManagerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCallManagerGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCallManagerGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddCallManagerGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCallManagerGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUserGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddUserGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addUserGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddUserGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addUserGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDhcpServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddDhcpServerReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addDhcpServer(\Losc\CucmBundle\Model\Webservice\StructType\AddDhcpServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addDhcpServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDhcpSubnet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddDhcpSubnetReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addDhcpSubnet(\Losc\CucmBundle\Model\Webservice\StructType\AddDhcpSubnetReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addDhcpSubnet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCallParkReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCallPark(\Losc\CucmBundle\Model\Webservice\StructType\AddCallParkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDirectedCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddDirectedCallParkReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addDirectedCallPark(\Losc\CucmBundle\Model\Webservice\StructType\AddDirectedCallParkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addDirectedCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMeetMe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddMeetMeReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addMeetMe(\Losc\CucmBundle\Model\Webservice\StructType\AddMeetMeReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addMeetMe($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMobileVoiceAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddMobileVoiceAccessReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addMobileVoiceAccess(\Losc\CucmBundle\Model\Webservice\StructType\AddMobileVoiceAccessReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addMobileVoiceAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRouteList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddRouteListReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addRouteList(\Losc\CucmBundle\Model\Webservice\StructType\AddRouteListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addRouteList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddUserReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addUser(\Losc\CucmBundle\Model\Webservice\StructType\AddUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addAppUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddAppUserReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addAppUser(\Losc\CucmBundle\Model\Webservice\StructType\AddAppUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addAppUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSipRealm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddSipRealmReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addSipRealm(\Losc\CucmBundle\Model\Webservice\StructType\AddSipRealmReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addSipRealm($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPhoneNtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddPhoneNtpReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addPhoneNtp(\Losc\CucmBundle\Model\Webservice\StructType\AddPhoneNtpReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addPhoneNtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDateTimeGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddDateTimeGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addDateTimeGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddDateTimeGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addDateTimeGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPresenceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddPresenceGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addPresenceGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddPresenceGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addPresenceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGeoLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddGeoLocationReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addGeoLocation(\Losc\CucmBundle\Model\Webservice\StructType\AddGeoLocationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addGeoLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSrst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddSrstReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addSrst(\Losc\CucmBundle\Model\Webservice\StructType\AddSrstReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addSrst($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMlppDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddMlppDomainReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addMlppDomain(\Losc\CucmBundle\Model\Webservice\StructType\AddMlppDomainReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addMlppDomain($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCumaServerSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCumaServerSecurityProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCumaServerSecurityProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddCumaServerSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCumaServerSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addApplicationServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddApplicationServerReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addApplicationServer(\Losc\CucmBundle\Model\Webservice\StructType\AddApplicationServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addApplicationServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addApplicationUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddApplicationUserCapfProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addApplicationUserCapfProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddApplicationUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addApplicationUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addEndUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddEndUserCapfProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addEndUserCapfProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddEndUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addEndUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUserPhoneAssociation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddUserPhoneAssociationReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addUserPhoneAssociation(\Losc\CucmBundle\Model\Webservice\StructType\AddUserPhoneAssociationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addUserPhoneAssociation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGeoLocationFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddGeoLocationFilterReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addGeoLocationFilter(\Losc\CucmBundle\Model\Webservice\StructType\AddGeoLocationFilterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addGeoLocationFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVoiceMailProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddVoiceMailProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addVoiceMailProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddVoiceMailProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addVoiceMailProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVoiceMailPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddVoiceMailPortReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addVoiceMailPort(\Losc\CucmBundle\Model\Webservice\StructType\AddVoiceMailPortReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addVoiceMailPort($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatekeeper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddGatekeeperReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addGatekeeper(\Losc\CucmBundle\Model\Webservice\StructType\AddGatekeeperReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addGatekeeper($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPhoneButtonTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddPhoneButtonTemplateReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addPhoneButtonTemplate(\Losc\CucmBundle\Model\Webservice\StructType\AddPhoneButtonTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addPhoneButtonTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCommonPhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCommonPhoneConfigReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCommonPhoneConfig(\Losc\CucmBundle\Model\Webservice\StructType\AddCommonPhoneConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCommonPhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMessageWaiting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddMessageWaitingReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addMessageWaiting(\Losc\CucmBundle\Model\Webservice\StructType\AddMessageWaitingReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addMessageWaiting($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addIpPhoneServices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddIpPhoneServicesReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addIpPhoneServices(\Losc\CucmBundle\Model\Webservice\StructType\AddIpPhoneServicesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addIpPhoneServices($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCtiRoutePoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCtiRoutePointReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCtiRoutePoint(\Losc\CucmBundle\Model\Webservice\StructType\AddCtiRoutePointReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCtiRoutePoint($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTransPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddTransPatternReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addTransPattern(\Losc\CucmBundle\Model\Webservice\StructType\AddTransPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addTransPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addCallingPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCallingPartyTransformationPatternReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCallingPartyTransformationPattern(\Losc\CucmBundle\Model\Webservice\StructType\AddCallingPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCallingPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSipRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddSipRoutePatternReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addSipRoutePattern(\Losc\CucmBundle\Model\Webservice\StructType\AddSipRoutePatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addSipRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addHuntPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddHuntPilotReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addHuntPilot(\Losc\CucmBundle\Model\Webservice\StructType\AddHuntPilotReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addHuntPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddRoutePatternReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addRoutePattern(\Losc\CucmBundle\Model\Webservice\StructType\AddRoutePatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addApplicationDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddApplicationDialRulesReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addApplicationDialRules(\Losc\CucmBundle\Model\Webservice\StructType\AddApplicationDialRulesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addApplicationDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDirectoryLookupDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddDirectoryLookupDialRulesReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addDirectoryLookupDialRules(\Losc\CucmBundle\Model\Webservice\StructType\AddDirectoryLookupDialRulesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addDirectoryLookupDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPhoneSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddPhoneSecurityProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addPhoneSecurityProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddPhoneSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addPhoneSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSipDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddSipDialRulesReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addSipDialRules(\Losc\CucmBundle\Model\Webservice\StructType\AddSipDialRulesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addSipDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addConferenceBridge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddConferenceBridgeReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addConferenceBridge(\Losc\CucmBundle\Model\Webservice\StructType\AddConferenceBridgeReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addConferenceBridge($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddMtpReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addMtp(\Losc\CucmBundle\Model\Webservice\StructType\AddMtpReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addMtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRemoteDestinationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddRemoteDestinationProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addRemoteDestinationProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddRemoteDestinationProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addRemoteDestinationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddLineReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addLine(\Losc\CucmBundle\Model\Webservice\StructType\AddLineReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addLine($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDefaultDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddDefaultDeviceProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addDefaultDeviceProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddDefaultDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addDefaultDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addH323Phone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddH323PhoneReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addH323Phone(\Losc\CucmBundle\Model\Webservice\StructType\AddH323PhoneReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addH323Phone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addH323Trunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddH323TrunkReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addH323Trunk(\Losc\CucmBundle\Model\Webservice\StructType\AddH323TrunkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addH323Trunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddPhoneReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addPhone(\Losc\CucmBundle\Model\Webservice\StructType\AddPhoneReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addPhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addH323Gateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddH323GatewayReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addH323Gateway(\Losc\CucmBundle\Model\Webservice\StructType\AddH323GatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addH323Gateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddDeviceProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addDeviceProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRemoteDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddRemoteDestinationReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addRemoteDestination(\Losc\CucmBundle\Model\Webservice\StructType\AddRemoteDestinationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addRemoteDestination($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVg224
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddVg224Req $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addVg224(\Losc\CucmBundle\Model\Webservice\StructType\AddVg224Req $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addVg224($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddGatewayReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addGateway(\Losc\CucmBundle\Model\Webservice\StructType\AddGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatewayEndpointAnalogAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddGatewayEndpointAnalogAccessReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addGatewayEndpointAnalogAccess(\Losc\CucmBundle\Model\Webservice\StructType\AddGatewayEndpointAnalogAccessReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addGatewayEndpointAnalogAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatewayEndpointDigitalAccessPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddGatewayEndpointDigitalAccessPriReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addGatewayEndpointDigitalAccessPri(\Losc\CucmBundle\Model\Webservice\StructType\AddGatewayEndpointDigitalAccessPriReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addGatewayEndpointDigitalAccessPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatewayEndpointDigitalAccessBri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddGatewayEndpointDigitalAccessBriReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addGatewayEndpointDigitalAccessBri(\Losc\CucmBundle\Model\Webservice\StructType\AddGatewayEndpointDigitalAccessBriReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addGatewayEndpointDigitalAccessBri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatewayEndpointDigitalAccessT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddGatewayEndpointDigitalAccessT1Req $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addGatewayEndpointDigitalAccessT1(\Losc\CucmBundle\Model\Webservice\StructType\AddGatewayEndpointDigitalAccessT1Req $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addGatewayEndpointDigitalAccessT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addCiscoCatalyst600024PortFXSGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCiscoCatalyst600024PortFXSGatewayReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCiscoCatalyst600024PortFXSGateway(\Losc\CucmBundle\Model\Webservice\StructType\AddCiscoCatalyst600024PortFXSGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCiscoCatalyst600024PortFXSGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCiscoCatalyst6000E1VoIPGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCiscoCatalyst6000E1VoIPGatewayReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCiscoCatalyst6000E1VoIPGateway(\Losc\CucmBundle\Model\Webservice\StructType\AddCiscoCatalyst6000E1VoIPGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCiscoCatalyst6000E1VoIPGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addCiscoCatalyst6000T1VoIPGatewayPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCiscoCatalyst6000T1VoIPGatewayPri(\Losc\CucmBundle\Model\Webservice\StructType\AddCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCiscoCatalyst6000T1VoIPGatewayPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addCiscoCatalyst6000T1VoIPGatewayT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCiscoCatalyst6000T1VoIPGatewayT1(\Losc\CucmBundle\Model\Webservice\StructType\AddCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCiscoCatalyst6000T1VoIPGatewayT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCallPickupGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCallPickupGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCallPickupGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddCallPickupGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCallPickupGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGeoLocationPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddGeoLocationPolicyReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addGeoLocationPolicy(\Losc\CucmBundle\Model\Webservice\StructType\AddGeoLocationPolicyReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addGeoLocationPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSipTrunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddSipTrunkReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addSipTrunk(\Losc\CucmBundle\Model\Webservice\StructType\AddSipTrunkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addSipTrunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addCalledPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCalledPartyTransformationPatternReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCalledPartyTransformationPattern(\Losc\CucmBundle\Model\Webservice\StructType\AddCalledPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCalledPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addExternalCallControlProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddExternalCallControlProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addExternalCallControlProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddExternalCallControlProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addExternalCallControlProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSafSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddSafSecurityProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addSafSecurityProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddSafSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addSafSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSafForwarder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddSafForwarderReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addSafForwarder(\Losc\CucmBundle\Model\Webservice\StructType\AddSafForwarderReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addSafForwarder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCcdHostedDN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCcdHostedDNReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCcdHostedDN(\Losc\CucmBundle\Model\Webservice\StructType\AddCcdHostedDNReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCcdHostedDN($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCcdHostedDNGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCcdHostedDNGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCcdHostedDNGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddCcdHostedDNGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCcdHostedDNGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCcdRequestingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCcdRequestingServiceReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCcdRequestingService(\Losc\CucmBundle\Model\Webservice\StructType\AddCcdRequestingServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCcdRequestingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRemoteCluster
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddRemoteClusterReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addRemoteCluster(\Losc\CucmBundle\Model\Webservice\StructType\AddRemoteClusterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addRemoteCluster($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCcdAdvertisingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCcdAdvertisingServiceReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCcdAdvertisingService(\Losc\CucmBundle\Model\Webservice\StructType\AddCcdAdvertisingServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCcdAdvertisingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUnitsToGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddUnitsToGatewayReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addUnitsToGateway(\Losc\CucmBundle\Model\Webservice\StructType\AddUnitsToGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addUnitsToGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatewaySubunits
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddGatewaySubunitsReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addGatewaySubunits(\Losc\CucmBundle\Model\Webservice\StructType\AddGatewaySubunitsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addGatewaySubunits($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLdapDirectory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddLdapDirectoryReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addLdapDirectory(\Losc\CucmBundle\Model\Webservice\StructType\AddLdapDirectoryReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addLdapDirectory($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSafCcdPurgeBlockLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddSafCcdPurgeBlockLearnedRoutesReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addSafCcdPurgeBlockLearnedRoutes(\Losc\CucmBundle\Model\Webservice\StructType\AddSafCcdPurgeBlockLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addSafCcdPurgeBlockLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVpnGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddVpnGatewayReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addVpnGateway(\Losc\CucmBundle\Model\Webservice\StructType\AddVpnGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addVpnGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVpnGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddVpnGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addVpnGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddVpnGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addVpnGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVpnProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddVpnProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addVpnProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddVpnProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addVpnProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddImeServerReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addImeServer(\Losc\CucmBundle\Model\Webservice\StructType\AddImeServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addImeServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeRouteFilterGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddImeRouteFilterGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addImeRouteFilterGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddImeRouteFilterGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addImeRouteFilterGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeRouteFilterElement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddImeRouteFilterElementReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addImeRouteFilterElement(\Losc\CucmBundle\Model\Webservice\StructType\AddImeRouteFilterElementReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addImeRouteFilterElement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddImeClientReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addImeClient(\Losc\CucmBundle\Model\Webservice\StructType\AddImeClientReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addImeClient($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeEnrolledPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddImeEnrolledPatternReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addImeEnrolledPattern(\Losc\CucmBundle\Model\Webservice\StructType\AddImeEnrolledPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addImeEnrolledPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeEnrolledPatternGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddImeEnrolledPatternGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addImeEnrolledPatternGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddImeEnrolledPatternGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addImeEnrolledPatternGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeExclusionNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddImeExclusionNumberReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addImeExclusionNumber(\Losc\CucmBundle\Model\Webservice\StructType\AddImeExclusionNumberReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addImeExclusionNumber($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeExclusionNumberGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddImeExclusionNumberGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addImeExclusionNumberGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddImeExclusionNumberGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addImeExclusionNumberGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeFirewall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddImeFirewallReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addImeFirewall(\Losc\CucmBundle\Model\Webservice\StructType\AddImeFirewallReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addImeFirewall($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeE164Transformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddImeE164TransformationReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addImeE164Transformation(\Losc\CucmBundle\Model\Webservice\StructType\AddImeE164TransformationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addImeE164Transformation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTransformationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddTransformationProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addTransformationProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddTransformationProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addTransformationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addFallbackProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddFallbackProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addFallbackProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddFallbackProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addFallbackProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLdapFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddLdapFilterReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addLdapFilter(\Losc\CucmBundle\Model\Webservice\StructType\AddLdapFilterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addLdapFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addAppServerInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddAppServerInfoReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addAppServerInfo(\Losc\CucmBundle\Model\Webservice\StructType\AddAppServerInfoReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addAppServerInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addFeatureControlPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddFeatureControlPolicyReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addFeatureControlPolicy(\Losc\CucmBundle\Model\Webservice\StructType\AddFeatureControlPolicyReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addFeatureControlPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMobilityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddMobilityProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addMobilityProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddMobilityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addMobilityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addEnterpriseFeatureAccessConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddEnterpriseFeatureAccessConfigurationReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addEnterpriseFeatureAccessConfiguration(\Losc\CucmBundle\Model\Webservice\StructType\AddEnterpriseFeatureAccessConfigurationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addEnterpriseFeatureAccessConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addHandoffConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddHandoffConfigurationReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addHandoffConfiguration(\Losc\CucmBundle\Model\Webservice\StructType\AddHandoffConfigurationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addHandoffConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCalledPartyTracing
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCalledPartyTracingReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCalledPartyTracing(\Losc\CucmBundle\Model\Webservice\StructType\AddCalledPartyTracingReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCalledPartyTracing($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSIPNormalizationScript
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddSIPNormalizationScriptReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addSIPNormalizationScript(\Losc\CucmBundle\Model\Webservice\StructType\AddSIPNormalizationScriptReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addSIPNormalizationScript($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCustomUserField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCustomUserFieldReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCustomUserField(\Losc\CucmBundle\Model\Webservice\StructType\AddCustomUserFieldReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCustomUserField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatewaySccpEndpoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddGatewaySccpEndpointsReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addGatewaySccpEndpoints(\Losc\CucmBundle\Model\Webservice\StructType\AddGatewaySccpEndpointsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addGatewaySccpEndpoints($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addBillingServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddBillingServerReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addBillingServer(\Losc\CucmBundle\Model\Webservice\StructType\AddBillingServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addBillingServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLbmGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddLbmGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addLbmGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddLbmGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addLbmGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addAnnouncement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddAnnouncementReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addAnnouncement(\Losc\CucmBundle\Model\Webservice\StructType\AddAnnouncementReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addAnnouncement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addServiceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddServiceProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addServiceProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddServiceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addServiceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLdapSyncCustomField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddLdapSyncCustomFieldReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addLdapSyncCustomField(\Losc\CucmBundle\Model\Webservice\StructType\AddLdapSyncCustomFieldReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addLdapSyncCustomField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addAudioCodecPreferenceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddAudioCodecPreferenceListReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addAudioCodecPreferenceList(\Losc\CucmBundle\Model\Webservice\StructType\AddAudioCodecPreferenceListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addAudioCodecPreferenceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUcService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddUcServiceReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addUcService(\Losc\CucmBundle\Model\Webservice\StructType\AddUcServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addUcService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLbmHubGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddLbmHubGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addLbmHubGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddLbmHubGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addLbmHubGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImportedDirectoryUriCatalogs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddImportedDirectoryUriCatalogsReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addImportedDirectoryUriCatalogs(\Losc\CucmBundle\Model\Webservice\StructType\AddImportedDirectoryUriCatalogsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addImportedDirectoryUriCatalogs($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVohServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddVohServerReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addVohServer(\Losc\CucmBundle\Model\Webservice\StructType\AddVohServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addVohServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSdpTransparencyProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddSdpTransparencyProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addSdpTransparencyProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddSdpTransparencyProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addSdpTransparencyProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addFeatureGroupTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddFeatureGroupTemplateReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addFeatureGroupTemplate(\Losc\CucmBundle\Model\Webservice\StructType\AddFeatureGroupTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addFeatureGroupTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDirNumberAliasLookupandSync
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddDirNumberAliasLookupandSyncReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addDirNumberAliasLookupandSync(\Losc\CucmBundle\Model\Webservice\StructType\AddDirNumberAliasLookupandSyncReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addDirNumberAliasLookupandSync($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLocalRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddLocalRouteGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addLocalRouteGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddLocalRouteGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addLocalRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addAdvertisedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddAdvertisedPatternsReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addAdvertisedPatterns(\Losc\CucmBundle\Model\Webservice\StructType\AddAdvertisedPatternsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addAdvertisedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addBlockedLearnedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddBlockedLearnedPatternsReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addBlockedLearnedPatterns(\Losc\CucmBundle\Model\Webservice\StructType\AddBlockedLearnedPatternsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addBlockedLearnedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCCAProfiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddCCAProfilesReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addCCAProfiles(\Losc\CucmBundle\Model\Webservice\StructType\AddCCAProfilesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addCCAProfiles($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUniversalDeviceTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddUniversalDeviceTemplateReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addUniversalDeviceTemplate(\Losc\CucmBundle\Model\Webservice\StructType\AddUniversalDeviceTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addUniversalDeviceTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUserProfileProvision
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddUserProfileProvisionReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addUserProfileProvision(\Losc\CucmBundle\Model\Webservice\StructType\AddUserProfileProvisionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addUserProfileProvision($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPresenceRedundancyGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddPresenceRedundancyGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addPresenceRedundancyGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddPresenceRedundancyGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addPresenceRedundancyGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addWifiHotspot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddWifiHotspotReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addWifiHotspot(\Losc\CucmBundle\Model\Webservice\StructType\AddWifiHotspotReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addWifiHotspot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addWlanProfileGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddWlanProfileGroupReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addWlanProfileGroup(\Losc\CucmBundle\Model\Webservice\StructType\AddWlanProfileGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addWlanProfileGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addWLANProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddWLANProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addWLANProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddWLANProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addWLANProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUniversalLineTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddUniversalLineTemplateReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addUniversalLineTemplate(\Losc\CucmBundle\Model\Webservice\StructType\AddUniversalLineTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addUniversalLineTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addNetworkAccessProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddNetworkAccessProfileReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addNetworkAccessProfile(\Losc\CucmBundle\Model\Webservice\StructType\AddNetworkAccessProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addNetworkAccessProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddMobilityReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addMobility(\Losc\CucmBundle\Model\Webservice\StructType\AddMobilityReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addApplicationToSoftkeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddApplicationToSoftkeyTemplateReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function addApplicationToSoftkeyTemplate(\Losc\CucmBundle\Model\Webservice\StructType\AddApplicationToSoftkeyTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addApplicationToSoftkeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSNMPCommunityString
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddSNMPCommunityStringReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AddSNMPCommunityStringRes|bool
     */
    public function addSNMPCommunityString(\Losc\CucmBundle\Model\Webservice\StructType\AddSNMPCommunityStringReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addSNMPCommunityString($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSNMPUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddSNMPUserReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AddSNMPUserRes|bool
     */
    public function addSNMPUser(\Losc\CucmBundle\Model\Webservice\StructType\AddSNMPUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->addSNMPUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AddSNMPCommunityStringRes|\Losc\CucmBundle\Model\Webservice\StructType\AddSNMPUserRes|\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
