<?php

namespace Losc\CucmBundle\Model\Webservice\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XSIPReroute EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XSIPReroute extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Never'
     * @return string 'Never'
     */
    const VALUE_NEVER = 'Never';
    /**
     * Constant for value 'Contact Header'
     * @return string 'Contact Header'
     */
    const VALUE_CONTACT_HEADER = 'Contact Header';
    /**
     * Constant for value 'Call-Info Header with purpose=x-cisco-origIP'
     * @return string 'Call-Info Header with purpose=x-cisco-origIP'
     */
    const VALUE_CALL_INFO_HEADER_WITH_PURPOSE_X_CISCO_ORIG_IP = 'Call-Info Header with purpose=x-cisco-origIP';
    /**
     * Return allowed values
     * @uses self::VALUE_NEVER
     * @uses self::VALUE_CONTACT_HEADER
     * @uses self::VALUE_CALL_INFO_HEADER_WITH_PURPOSE_X_CISCO_ORIG_IP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEVER,
            self::VALUE_CONTACT_HEADER,
            self::VALUE_CALL_INFO_HEADER_WITH_PURPOSE_X_CISCO_ORIG_IP,
        );
    }
}
