<?php

namespace Losc\CucmBundle\Model\Webservice\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XConnectProtocol EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XConnectProtocol extends AbstractStructEnumBase
{
    /**
     * Constant for value 'HTTP'
     * @return string 'HTTP'
     */
    const VALUE_HTTP = 'HTTP';
    /**
     * Constant for value 'HTTPS'
     * @return string 'HTTPS'
     */
    const VALUE_HTTPS = 'HTTPS';
    /**
     * Constant for value 'TCP'
     * @return string 'TCP'
     */
    const VALUE_TCP = 'TCP';
    /**
     * Constant for value 'TCP + UDP'
     * @return string 'TCP + UDP'
     */
    const VALUE_TCP_UDP = 'TCP + UDP';
    /**
     * Constant for value 'UDP'
     * @return string 'UDP'
     */
    const VALUE_UDP = 'UDP';
    /**
     * Constant for value 'SSL'
     * @return string 'SSL'
     */
    const VALUE_SSL = 'SSL';
    /**
     * Constant for value 'TLS'
     * @return string 'TLS'
     */
    const VALUE_TLS = 'TLS';
    /**
     * Constant for value 'SIP'
     * @return string 'SIP'
     */
    const VALUE_SIP = 'SIP';
    /**
     * Constant for value 'OWA'
     * @return string 'OWA'
     */
    const VALUE_OWA = 'OWA';
    /**
     * Constant for value 'SOAP'
     * @return string 'SOAP'
     */
    const VALUE_SOAP = 'SOAP';
    /**
     * Constant for value 'EWS'
     * @return string 'EWS'
     */
    const VALUE_EWS = 'EWS';
    /**
     * Constant for value 'XMPP'
     * @return string 'XMPP'
     */
    const VALUE_XMPP = 'XMPP';
    /**
     * Return allowed values
     * @uses self::VALUE_HTTP
     * @uses self::VALUE_HTTPS
     * @uses self::VALUE_TCP
     * @uses self::VALUE_TCP_UDP
     * @uses self::VALUE_UDP
     * @uses self::VALUE_SSL
     * @uses self::VALUE_TLS
     * @uses self::VALUE_SIP
     * @uses self::VALUE_OWA
     * @uses self::VALUE_SOAP
     * @uses self::VALUE_EWS
     * @uses self::VALUE_XMPP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HTTP,
            self::VALUE_HTTPS,
            self::VALUE_TCP,
            self::VALUE_TCP_UDP,
            self::VALUE_UDP,
            self::VALUE_SSL,
            self::VALUE_TLS,
            self::VALUE_SIP,
            self::VALUE_OWA,
            self::VALUE_SOAP,
            self::VALUE_EWS,
            self::VALUE_XMPP,
        );
    }
}
