<?php

namespace Losc\CucmBundle\Model\Webservice\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XCallingLineIdentification EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XCallingLineIdentification extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'Strict From URI presentation Only'
     * @return string 'Strict From URI presentation Only'
     */
    const VALUE_STRICT_FROM_URI_PRESENTATION_ONLY = 'Strict From URI presentation Only';
    /**
     * Constant for value 'Strict Identity Headers presentation Only'
     * @return string 'Strict Identity Headers presentation Only'
     */
    const VALUE_STRICT_IDENTITY_HEADERS_PRESENTATION_ONLY = 'Strict Identity Headers presentation Only';
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_STRICT_FROM_URI_PRESENTATION_ONLY
     * @uses self::VALUE_STRICT_IDENTITY_HEADERS_PRESENTATION_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT,
            self::VALUE_STRICT_FROM_URI_PRESENTATION_ONLY,
            self::VALUE_STRICT_IDENTITY_HEADERS_PRESENTATION_ONLY,
        );
    }
}
