<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XVpnGatewayMember StructType
 * @subpackage Structs
 */
class XVpnGatewayMember extends AbstractStructBase
{
    /**
     * The issuerName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $issuerName;
    /**
     * The serialNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $serialNumber;
    /**
     * Constructor method for XVpnGatewayMember
     * @uses XVpnGatewayMember::setIssuerName()
     * @uses XVpnGatewayMember::setSerialNumber()
     * @param string $issuerName
     * @param string $serialNumber
     */
    public function __construct($issuerName = null, $serialNumber = null)
    {
        $this
            ->setIssuerName($issuerName)
            ->setSerialNumber($serialNumber);
    }
    /**
     * Get issuerName value
     * @return string
     */
    public function getIssuerName()
    {
        return $this->issuerName;
    }
    /**
     * Set issuerName value
     * @param string $issuerName
     * @return \StructType\XVpnGatewayMember
     */
    public function setIssuerName($issuerName = null)
    {
        // validation for constraint: string
        if (!is_null($issuerName) && !is_string($issuerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuerName, true), gettype($issuerName)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($issuerName) && mb_strlen($issuerName) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($issuerName)), __LINE__);
        }
        $this->issuerName = $issuerName;
        return $this;
    }
    /**
     * Get serialNumber value
     * @return string
     */
    public function getSerialNumber()
    {
        return $this->serialNumber;
    }
    /**
     * Set serialNumber value
     * @param string $serialNumber
     * @return \StructType\XVpnGatewayMember
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumber, true), gettype($serialNumber)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($serialNumber) && mb_strlen($serialNumber) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($serialNumber)), __LINE__);
        }
        $this->serialNumber = $serialNumber;
        return $this;
    }
}
