<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XVohServer StructType
 * @subpackage Structs
 */
class XVohServer extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The sipTrunkName
     * Meta information extracted from the WSDL
     * - documentation: SIP Trunk for Video On Hold Server
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * The defaultVideoStreamId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $defaultVideoStreamId;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * Constructor method for XVohServer
     * @uses XVohServer::setName()
     * @uses XVohServer::setSipTrunkName()
     * @uses XVohServer::setDefaultVideoStreamId()
     * @uses XVohServer::setDescription()
     * @param string $name
     * @param \StructType\XFkType $sipTrunkName
     * @param string $defaultVideoStreamId
     * @param string $description
     */
    public function __construct($name = null, \StructType\XFkType $sipTrunkName = null, $defaultVideoStreamId = null, $description = null)
    {
        $this
            ->setName($name)
            ->setSipTrunkName($sipTrunkName)
            ->setDefaultVideoStreamId($defaultVideoStreamId)
            ->setDescription($description);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XVohServer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \StructType\XFkType
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \StructType\XFkType $sipTrunkName
     * @return \StructType\XVohServer
     */
    public function setSipTrunkName(\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get defaultVideoStreamId value
     * @return string
     */
    public function getDefaultVideoStreamId()
    {
        return $this->defaultVideoStreamId;
    }
    /**
     * Set defaultVideoStreamId value
     * @param string $defaultVideoStreamId
     * @return \StructType\XVohServer
     */
    public function setDefaultVideoStreamId($defaultVideoStreamId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultVideoStreamId) && !is_string($defaultVideoStreamId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultVideoStreamId, true), gettype($defaultVideoStreamId)), __LINE__);
        }
        $this->defaultVideoStreamId = $defaultVideoStreamId;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XVohServer
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
}
