<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XTimeSchedule StructType
 * @subpackage Structs
 */
class XTimeSchedule extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Members
     */
    public $members;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The isPublished
     * Meta information extracted from the WSDL
     * - documentation: TimeSchedule cannot be published if it has a todOwnerId assigned to it. Only Administrative Time Schedule can be published.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPublished;
    /**
     * The timeScheduleCategory
     * Meta information extracted from the WSDL
     * - default: Regular
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timeScheduleCategory;
    /**
     * The todOwnerIdName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $todOwnerIdName;
    /**
     * Constructor method for XTimeSchedule
     * @uses XTimeSchedule::setName()
     * @uses XTimeSchedule::setMembers()
     * @uses XTimeSchedule::setDescription()
     * @uses XTimeSchedule::setIsPublished()
     * @uses XTimeSchedule::setTimeScheduleCategory()
     * @uses XTimeSchedule::setTodOwnerIdName()
     * @param string $name
     * @param \StructType\Members $members
     * @param string $description
     * @param string $isPublished
     * @param string $timeScheduleCategory
     * @param \StructType\XFkType $todOwnerIdName
     */
    public function __construct($name = null, \StructType\Members $members = null, $description = null, $isPublished = 'false', $timeScheduleCategory = 'Regular', \StructType\XFkType $todOwnerIdName = null)
    {
        $this
            ->setName($name)
            ->setMembers($members)
            ->setDescription($description)
            ->setIsPublished($isPublished)
            ->setTimeScheduleCategory($timeScheduleCategory)
            ->setTodOwnerIdName($todOwnerIdName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XTimeSchedule
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\Members $members
     * @return \StructType\XTimeSchedule
     */
    public function setMembers(\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XTimeSchedule
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isPublished value
     * @return string|null
     */
    public function getIsPublished()
    {
        return $this->isPublished;
    }
    /**
     * Set isPublished value
     * @param string $isPublished
     * @return \StructType\XTimeSchedule
     */
    public function setIsPublished($isPublished = 'false')
    {
        // validation for constraint: string
        if (!is_null($isPublished) && !is_string($isPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isPublished, true), gettype($isPublished)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isPublished) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isPublished, true)), __LINE__);
        }
        $this->isPublished = $isPublished;
        return $this;
    }
    /**
     * Get timeScheduleCategory value
     * @return string|null
     */
    public function getTimeScheduleCategory()
    {
        return $this->timeScheduleCategory;
    }
    /**
     * Set timeScheduleCategory value
     * @uses \EnumType\XTimeScheduleCategory::valueIsValid()
     * @uses \EnumType\XTimeScheduleCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeScheduleCategory
     * @return \StructType\XTimeSchedule
     */
    public function setTimeScheduleCategory($timeScheduleCategory = 'Regular')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTimeScheduleCategory::valueIsValid($timeScheduleCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTimeScheduleCategory', is_array($timeScheduleCategory) ? implode(', ', $timeScheduleCategory) : var_export($timeScheduleCategory, true), implode(', ', \EnumType\XTimeScheduleCategory::getValidValues())), __LINE__);
        }
        $this->timeScheduleCategory = $timeScheduleCategory;
        return $this;
    }
    /**
     * Get todOwnerIdName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getTodOwnerIdName()
    {
        return isset($this->todOwnerIdName) ? $this->todOwnerIdName : null;
    }
    /**
     * Set todOwnerIdName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $todOwnerIdName
     * @return \StructType\XTimeSchedule
     */
    public function setTodOwnerIdName(\StructType\XFkType $todOwnerIdName = null)
    {
        if (is_null($todOwnerIdName) || (is_array($todOwnerIdName) && empty($todOwnerIdName))) {
            unset($this->todOwnerIdName);
        } else {
            $this->todOwnerIdName = $todOwnerIdName;
        }
        return $this;
    }
}
