<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSrst StructType
 * @subpackage Structs
 */
class XSrst extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - default: 2000
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The SipPort
     * Meta information extracted from the WSDL
     * - default: 5060
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $SipPort;
    /**
     * The SipNetwork
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $SipNetwork;
    /**
     * The isSecure
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isSecure;
    /**
     * Constructor method for XSrst
     * @uses XSrst::setName()
     * @uses XSrst::setPort()
     * @uses XSrst::setIpAddress()
     * @uses XSrst::setSipPort()
     * @uses XSrst::setSipNetwork()
     * @uses XSrst::setIsSecure()
     * @param string $name
     * @param string $port
     * @param string $ipAddress
     * @param string $sipPort
     * @param string $sipNetwork
     * @param string $isSecure
     */
    public function __construct($name = null, $port = '2000', $ipAddress = null, $sipPort = '5060', $sipNetwork = null, $isSecure = null)
    {
        $this
            ->setName($name)
            ->setPort($port)
            ->setIpAddress($ipAddress)
            ->setSipPort($sipPort)
            ->setSipNetwork($sipNetwork)
            ->setIsSecure($isSecure);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XSrst
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get port value
     * @return string
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \StructType\XSrst
     */
    public function setPort($port = '2000')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($port) ? implode(', ', $port) : var_export($port, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \StructType\XSrst
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipAddress, true), gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get SipPort value
     * @return string
     */
    public function getSipPort()
    {
        return $this->SipPort;
    }
    /**
     * Set SipPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipPort
     * @return \StructType\XSrst
     */
    public function setSipPort($sipPort = '5060')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($sipPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($sipPort) ? implode(', ', $sipPort) : var_export($sipPort, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->SipPort = $sipPort;
        return $this;
    }
    /**
     * Get SipNetwork value
     * @return string|null
     */
    public function getSipNetwork()
    {
        return $this->SipNetwork;
    }
    /**
     * Set SipNetwork value
     * @param string $sipNetwork
     * @return \StructType\XSrst
     */
    public function setSipNetwork($sipNetwork = null)
    {
        // validation for constraint: string
        if (!is_null($sipNetwork) && !is_string($sipNetwork)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sipNetwork, true), gettype($sipNetwork)), __LINE__);
        }
        $this->SipNetwork = $sipNetwork;
        return $this;
    }
    /**
     * Get isSecure value
     * @return string|null
     */
    public function getIsSecure()
    {
        return $this->isSecure;
    }
    /**
     * Set isSecure value
     * @param string $isSecure
     * @return \StructType\XSrst
     */
    public function setIsSecure($isSecure = null)
    {
        // validation for constraint: string
        if (!is_null($isSecure) && !is_string($isSecure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isSecure, true), gettype($isSecure)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isSecure) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isSecure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isSecure, true)), __LINE__);
        }
        $this->isSecure = $isSecure;
        return $this;
    }
}
