<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSipTrunkDestination StructType
 * @subpackage Structs
 */
class XSipTrunkDestination extends AbstractStructBase
{
    /**
     * The sortOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sortOrder;
    /**
     * The addressIpv4
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $addressIpv4;
    /**
     * The addressIpv6
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $addressIpv6;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - default: 5060
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $port;
    /**
     * Constructor method for XSipTrunkDestination
     * @uses XSipTrunkDestination::setSortOrder()
     * @uses XSipTrunkDestination::setAddressIpv4()
     * @uses XSipTrunkDestination::setAddressIpv6()
     * @uses XSipTrunkDestination::setPort()
     * @param string $sortOrder
     * @param string $addressIpv4
     * @param string $addressIpv6
     * @param string $port
     */
    public function __construct($sortOrder = null, $addressIpv4 = null, $addressIpv6 = null, $port = '5060')
    {
        $this
            ->setSortOrder($sortOrder)
            ->setAddressIpv4($addressIpv4)
            ->setAddressIpv6($addressIpv6)
            ->setPort($port);
    }
    /**
     * Get sortOrder value
     * @return string
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortOrder
     * @return \StructType\XSipTrunkDestination
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($sortOrder) ? implode(', ', $sortOrder) : var_export($sortOrder, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get addressIpv4 value
     * @return string|null
     */
    public function getAddressIpv4()
    {
        return $this->addressIpv4;
    }
    /**
     * Set addressIpv4 value
     * @param string $addressIpv4
     * @return \StructType\XSipTrunkDestination
     */
    public function setAddressIpv4($addressIpv4 = null)
    {
        // validation for constraint: string
        if (!is_null($addressIpv4) && !is_string($addressIpv4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressIpv4, true), gettype($addressIpv4)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($addressIpv4) && mb_strlen($addressIpv4) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($addressIpv4)), __LINE__);
        }
        $this->addressIpv4 = $addressIpv4;
        return $this;
    }
    /**
     * Get addressIpv6 value
     * @return string|null
     */
    public function getAddressIpv6()
    {
        return $this->addressIpv6;
    }
    /**
     * Set addressIpv6 value
     * @param string $addressIpv6
     * @return \StructType\XSipTrunkDestination
     */
    public function setAddressIpv6($addressIpv6 = null)
    {
        // validation for constraint: string
        if (!is_null($addressIpv6) && !is_string($addressIpv6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressIpv6, true), gettype($addressIpv6)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($addressIpv6) && mb_strlen($addressIpv6) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($addressIpv6)), __LINE__);
        }
        $this->addressIpv6 = $addressIpv6;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \StructType\XSipTrunkDestination
     */
    public function setPort($port = '5060')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($port) ? implode(', ', $port) : var_export($port, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
}
