<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSipRealm StructType
 * @subpackage Structs
 */
class XSipRealm extends AbstractStructBase
{
    /**
     * The realm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $realm;
    /**
     * The userid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userid;
    /**
     * The digestCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $digestCredentials;
    /**
     * Constructor method for XSipRealm
     * @uses XSipRealm::setRealm()
     * @uses XSipRealm::setUserid()
     * @uses XSipRealm::setDigestCredentials()
     * @param string $realm
     * @param string $userid
     * @param string $digestCredentials
     */
    public function __construct($realm = null, $userid = null, $digestCredentials = null)
    {
        $this
            ->setRealm($realm)
            ->setUserid($userid)
            ->setDigestCredentials($digestCredentials);
    }
    /**
     * Get realm value
     * @return string
     */
    public function getRealm()
    {
        return $this->realm;
    }
    /**
     * Set realm value
     * @param string $realm
     * @return \StructType\XSipRealm
     */
    public function setRealm($realm = null)
    {
        // validation for constraint: string
        if (!is_null($realm) && !is_string($realm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($realm, true), gettype($realm)), __LINE__);
        }
        $this->realm = $realm;
        return $this;
    }
    /**
     * Get userid value
     * @return string
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \StructType\XSipRealm
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userid, true), gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get digestCredentials value
     * @return string
     */
    public function getDigestCredentials()
    {
        return $this->digestCredentials;
    }
    /**
     * Set digestCredentials value
     * @param string $digestCredentials
     * @return \StructType\XSipRealm
     */
    public function setDigestCredentials($digestCredentials = null)
    {
        // validation for constraint: string
        if (!is_null($digestCredentials) && !is_string($digestCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digestCredentials, true), gettype($digestCredentials)), __LINE__);
        }
        $this->digestCredentials = $digestCredentials;
        return $this;
    }
}
