<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSafForwarder StructType
 * @subpackage Structs
 */
class XSafForwarder extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The clientLabel
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $clientLabel;
    /**
     * The safSecurityProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $safSecurityProfile;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - default: 5050
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * The enableTcpKeepAlive
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableTcpKeepAlive;
    /**
     * The safReconnectInterval
     * Meta information extracted from the WSDL
     * - default: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $safReconnectInterval;
    /**
     * The safNotificationsWindowSize
     * Meta information extracted from the WSDL
     * - default: 7
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $safNotificationsWindowSize;
    /**
     * The associatedCucms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AssociatedCucms
     */
    public $associatedCucms;
    /**
     * Constructor method for XSafForwarder
     * @uses XSafForwarder::setName()
     * @uses XSafForwarder::setClientLabel()
     * @uses XSafForwarder::setSafSecurityProfile()
     * @uses XSafForwarder::setIpAddress()
     * @uses XSafForwarder::setDescription()
     * @uses XSafForwarder::setPort()
     * @uses XSafForwarder::setEnableTcpKeepAlive()
     * @uses XSafForwarder::setSafReconnectInterval()
     * @uses XSafForwarder::setSafNotificationsWindowSize()
     * @uses XSafForwarder::setAssociatedCucms()
     * @param string $name
     * @param string $clientLabel
     * @param \StructType\XFkType $safSecurityProfile
     * @param string $ipAddress
     * @param string $description
     * @param string $port
     * @param string $enableTcpKeepAlive
     * @param string $safReconnectInterval
     * @param string $safNotificationsWindowSize
     * @param \StructType\AssociatedCucms $associatedCucms
     */
    public function __construct($name = null, $clientLabel = null, \StructType\XFkType $safSecurityProfile = null, $ipAddress = null, $description = null, $port = '5050', $enableTcpKeepAlive = 'true', $safReconnectInterval = '20', $safNotificationsWindowSize = '7', \StructType\AssociatedCucms $associatedCucms = null)
    {
        $this
            ->setName($name)
            ->setClientLabel($clientLabel)
            ->setSafSecurityProfile($safSecurityProfile)
            ->setIpAddress($ipAddress)
            ->setDescription($description)
            ->setPort($port)
            ->setEnableTcpKeepAlive($enableTcpKeepAlive)
            ->setSafReconnectInterval($safReconnectInterval)
            ->setSafNotificationsWindowSize($safNotificationsWindowSize)
            ->setAssociatedCucms($associatedCucms);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XSafForwarder
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($name) && mb_strlen($name) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get clientLabel value
     * @return string
     */
    public function getClientLabel()
    {
        return $this->clientLabel;
    }
    /**
     * Set clientLabel value
     * @param string $clientLabel
     * @return \StructType\XSafForwarder
     */
    public function setClientLabel($clientLabel = null)
    {
        // validation for constraint: string
        if (!is_null($clientLabel) && !is_string($clientLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientLabel, true), gettype($clientLabel)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($clientLabel) && mb_strlen($clientLabel) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($clientLabel)), __LINE__);
        }
        $this->clientLabel = $clientLabel;
        return $this;
    }
    /**
     * Get safSecurityProfile value
     * @return \StructType\XFkType
     */
    public function getSafSecurityProfile()
    {
        return $this->safSecurityProfile;
    }
    /**
     * Set safSecurityProfile value
     * @param \StructType\XFkType $safSecurityProfile
     * @return \StructType\XSafForwarder
     */
    public function setSafSecurityProfile(\StructType\XFkType $safSecurityProfile = null)
    {
        $this->safSecurityProfile = $safSecurityProfile;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \StructType\XSafForwarder
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipAddress, true), gettype($ipAddress)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($ipAddress) && mb_strlen($ipAddress) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XSafForwarder
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \StructType\XSafForwarder
     */
    public function setPort($port = '5050')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($port) ? implode(', ', $port) : var_export($port, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get enableTcpKeepAlive value
     * @return string|null
     */
    public function getEnableTcpKeepAlive()
    {
        return $this->enableTcpKeepAlive;
    }
    /**
     * Set enableTcpKeepAlive value
     * @param string $enableTcpKeepAlive
     * @return \StructType\XSafForwarder
     */
    public function setEnableTcpKeepAlive($enableTcpKeepAlive = 'true')
    {
        // validation for constraint: string
        if (!is_null($enableTcpKeepAlive) && !is_string($enableTcpKeepAlive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableTcpKeepAlive, true), gettype($enableTcpKeepAlive)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableTcpKeepAlive) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableTcpKeepAlive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableTcpKeepAlive, true)), __LINE__);
        }
        $this->enableTcpKeepAlive = $enableTcpKeepAlive;
        return $this;
    }
    /**
     * Get safReconnectInterval value
     * @return string|null
     */
    public function getSafReconnectInterval()
    {
        return $this->safReconnectInterval;
    }
    /**
     * Set safReconnectInterval value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $safReconnectInterval
     * @return \StructType\XSafForwarder
     */
    public function setSafReconnectInterval($safReconnectInterval = '20')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($safReconnectInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($safReconnectInterval) ? implode(', ', $safReconnectInterval) : var_export($safReconnectInterval, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->safReconnectInterval = $safReconnectInterval;
        return $this;
    }
    /**
     * Get safNotificationsWindowSize value
     * @return string|null
     */
    public function getSafNotificationsWindowSize()
    {
        return $this->safNotificationsWindowSize;
    }
    /**
     * Set safNotificationsWindowSize value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $safNotificationsWindowSize
     * @return \StructType\XSafForwarder
     */
    public function setSafNotificationsWindowSize($safNotificationsWindowSize = '7')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($safNotificationsWindowSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($safNotificationsWindowSize) ? implode(', ', $safNotificationsWindowSize) : var_export($safNotificationsWindowSize, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->safNotificationsWindowSize = $safNotificationsWindowSize;
        return $this;
    }
    /**
     * Get associatedCucms value
     * @return \StructType\AssociatedCucms|null
     */
    public function getAssociatedCucms()
    {
        return $this->associatedCucms;
    }
    /**
     * Set associatedCucms value
     * @param \StructType\AssociatedCucms $associatedCucms
     * @return \StructType\XSafForwarder
     */
    public function setAssociatedCucms(\StructType\AssociatedCucms $associatedCucms = null)
    {
        $this->associatedCucms = $associatedCucms;
        return $this;
    }
}
