<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRouteGroup StructType
 * @subpackage Structs
 */
class XRouteGroup extends AbstractStructBase
{
    /**
     * The distributionAlgorithm
     * Meta information extracted from the WSDL
     * - default: Circular
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $distributionAlgorithm;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Members
     */
    public $members;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * Constructor method for XRouteGroup
     * @uses XRouteGroup::setDistributionAlgorithm()
     * @uses XRouteGroup::setMembers()
     * @uses XRouteGroup::setName()
     * @param string $distributionAlgorithm
     * @param \StructType\Members $members
     * @param string $name
     */
    public function __construct($distributionAlgorithm = 'Circular', \StructType\Members $members = null, $name = null)
    {
        $this
            ->setDistributionAlgorithm($distributionAlgorithm)
            ->setMembers($members)
            ->setName($name);
    }
    /**
     * Get distributionAlgorithm value
     * @return string
     */
    public function getDistributionAlgorithm()
    {
        return $this->distributionAlgorithm;
    }
    /**
     * Set distributionAlgorithm value
     * @uses \EnumType\XDistributeAlgorithm::valueIsValid()
     * @uses \EnumType\XDistributeAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distributionAlgorithm
     * @return \StructType\XRouteGroup
     */
    public function setDistributionAlgorithm($distributionAlgorithm = 'Circular')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDistributeAlgorithm::valueIsValid($distributionAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XDistributeAlgorithm', is_array($distributionAlgorithm) ? implode(', ', $distributionAlgorithm) : var_export($distributionAlgorithm, true), implode(', ', \EnumType\XDistributeAlgorithm::getValidValues())), __LINE__);
        }
        $this->distributionAlgorithm = $distributionAlgorithm;
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\Members $members
     * @return \StructType\XRouteGroup
     */
    public function setMembers(\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XRouteGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
}
