<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XResourcePriorityNamespace StructType
 * @subpackage Structs
 */
class XResourcePriorityNamespace extends AbstractStructBase
{
    /**
     * The namespace
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $namespace;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefault;
    /**
     * Constructor method for XResourcePriorityNamespace
     * @uses XResourcePriorityNamespace::setNamespace()
     * @uses XResourcePriorityNamespace::setDescription()
     * @uses XResourcePriorityNamespace::setIsDefault()
     * @param string $namespace
     * @param string $description
     * @param string $isDefault
     */
    public function __construct($namespace = null, $description = null, $isDefault = null)
    {
        $this
            ->setNamespace($namespace)
            ->setDescription($description)
            ->setIsDefault($isDefault);
    }
    /**
     * Get namespace value
     * @return string
     */
    public function getNamespace()
    {
        return $this->namespace;
    }
    /**
     * Set namespace value
     * @param string $namespace
     * @return \StructType\XResourcePriorityNamespace
     */
    public function setNamespace($namespace = null)
    {
        // validation for constraint: string
        if (!is_null($namespace) && !is_string($namespace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namespace, true), gettype($namespace)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($namespace) && mb_strlen($namespace) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($namespace)), __LINE__);
        }
        $this->namespace = $namespace;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XResourcePriorityNamespace
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isDefault value
     * @return string|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param string $isDefault
     * @return \StructType\XResourcePriorityNamespace
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: string
        if (!is_null($isDefault) && !is_string($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isDefault, true)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
}
