<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRemoteCluster StructType
 * @subpackage Structs
 */
class XRemoteCluster extends AbstractStructBase
{
    /**
     * The clusterId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $clusterId;
    /**
     * The fullyQualifiedName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $fullyQualifiedName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The emcc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $emcc;
    /**
     * The pstnAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $pstnAccess;
    /**
     * The rsvpAgent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $rsvpAgent;
    /**
     * The tftp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $tftp;
    /**
     * The lbm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $lbm;
    /**
     * The uds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $uds;
    /**
     * Constructor method for XRemoteCluster
     * @uses XRemoteCluster::setClusterId()
     * @uses XRemoteCluster::setFullyQualifiedName()
     * @uses XRemoteCluster::setDescription()
     * @uses XRemoteCluster::setEmcc()
     * @uses XRemoteCluster::setPstnAccess()
     * @uses XRemoteCluster::setRsvpAgent()
     * @uses XRemoteCluster::setTftp()
     * @uses XRemoteCluster::setLbm()
     * @uses XRemoteCluster::setUds()
     * @param string $clusterId
     * @param string $fullyQualifiedName
     * @param string $description
     * @param \StructType\XRemoteClusterMember $emcc
     * @param \StructType\XRemoteClusterMember $pstnAccess
     * @param \StructType\XRemoteClusterMember $rsvpAgent
     * @param \StructType\XRemoteClusterMember $tftp
     * @param \StructType\XRemoteClusterMember $lbm
     * @param \StructType\XRemoteClusterMember $uds
     */
    public function __construct($clusterId = null, $fullyQualifiedName = null, $description = null, \StructType\XRemoteClusterMember $emcc = null, \StructType\XRemoteClusterMember $pstnAccess = null, \StructType\XRemoteClusterMember $rsvpAgent = null, \StructType\XRemoteClusterMember $tftp = null, \StructType\XRemoteClusterMember $lbm = null, \StructType\XRemoteClusterMember $uds = null)
    {
        $this
            ->setClusterId($clusterId)
            ->setFullyQualifiedName($fullyQualifiedName)
            ->setDescription($description)
            ->setEmcc($emcc)
            ->setPstnAccess($pstnAccess)
            ->setRsvpAgent($rsvpAgent)
            ->setTftp($tftp)
            ->setLbm($lbm)
            ->setUds($uds);
    }
    /**
     * Get clusterId value
     * @return string
     */
    public function getClusterId()
    {
        return $this->clusterId;
    }
    /**
     * Set clusterId value
     * @param string $clusterId
     * @return \StructType\XRemoteCluster
     */
    public function setClusterId($clusterId = null)
    {
        // validation for constraint: string
        if (!is_null($clusterId) && !is_string($clusterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clusterId, true), gettype($clusterId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($clusterId) && mb_strlen($clusterId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($clusterId)), __LINE__);
        }
        $this->clusterId = $clusterId;
        return $this;
    }
    /**
     * Get fullyQualifiedName value
     * @return string
     */
    public function getFullyQualifiedName()
    {
        return $this->fullyQualifiedName;
    }
    /**
     * Set fullyQualifiedName value
     * @param string $fullyQualifiedName
     * @return \StructType\XRemoteCluster
     */
    public function setFullyQualifiedName($fullyQualifiedName = null)
    {
        // validation for constraint: string
        if (!is_null($fullyQualifiedName) && !is_string($fullyQualifiedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullyQualifiedName, true), gettype($fullyQualifiedName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($fullyQualifiedName) && mb_strlen($fullyQualifiedName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($fullyQualifiedName)), __LINE__);
        }
        $this->fullyQualifiedName = $fullyQualifiedName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XRemoteCluster
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get emcc value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getEmcc()
    {
        return $this->emcc;
    }
    /**
     * Set emcc value
     * @param \StructType\XRemoteClusterMember $emcc
     * @return \StructType\XRemoteCluster
     */
    public function setEmcc(\StructType\XRemoteClusterMember $emcc = null)
    {
        $this->emcc = $emcc;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param \StructType\XRemoteClusterMember $pstnAccess
     * @return \StructType\XRemoteCluster
     */
    public function setPstnAccess(\StructType\XRemoteClusterMember $pstnAccess = null)
    {
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get rsvpAgent value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getRsvpAgent()
    {
        return $this->rsvpAgent;
    }
    /**
     * Set rsvpAgent value
     * @param \StructType\XRemoteClusterMember $rsvpAgent
     * @return \StructType\XRemoteCluster
     */
    public function setRsvpAgent(\StructType\XRemoteClusterMember $rsvpAgent = null)
    {
        $this->rsvpAgent = $rsvpAgent;
        return $this;
    }
    /**
     * Get tftp value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getTftp()
    {
        return $this->tftp;
    }
    /**
     * Set tftp value
     * @param \StructType\XRemoteClusterMember $tftp
     * @return \StructType\XRemoteCluster
     */
    public function setTftp(\StructType\XRemoteClusterMember $tftp = null)
    {
        $this->tftp = $tftp;
        return $this;
    }
    /**
     * Get lbm value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getLbm()
    {
        return $this->lbm;
    }
    /**
     * Set lbm value
     * @param \StructType\XRemoteClusterMember $lbm
     * @return \StructType\XRemoteCluster
     */
    public function setLbm(\StructType\XRemoteClusterMember $lbm = null)
    {
        $this->lbm = $lbm;
        return $this;
    }
    /**
     * Get uds value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getUds()
    {
        return $this->uds;
    }
    /**
     * Set uds value
     * @param \StructType\XRemoteClusterMember $uds
     * @return \StructType\XRemoteCluster
     */
    public function setUds(\StructType\XRemoteClusterMember $uds = null)
    {
        $this->uds = $uds;
        return $this;
    }
}
