<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRegionRelationship StructType
 * @subpackage Structs
 */
class XRegionRelationship extends AbstractStructBase
{
    /**
     * The regionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\XFkType
     */
    public $regionName;
    /**
     * The bandwidth
     * Meta information extracted from the WSDL
     * - default: G.711
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $bandwidth;
    /**
     * The videoBandwidth
     * Meta information extracted from the WSDL
     * - default: 384
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $videoBandwidth;
    /**
     * The immersiveVideoBandwidth
     * Meta information extracted from the WSDL
     * - default: 2147483647
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $immersiveVideoBandwidth;
    /**
     * The lossyNetwork
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lossyNetwork;
    /**
     * The codecPreference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $codecPreference;
    /**
     * Constructor method for XRegionRelationship
     * @uses XRegionRelationship::setRegionName()
     * @uses XRegionRelationship::setBandwidth()
     * @uses XRegionRelationship::setVideoBandwidth()
     * @uses XRegionRelationship::setImmersiveVideoBandwidth()
     * @uses XRegionRelationship::setLossyNetwork()
     * @uses XRegionRelationship::setCodecPreference()
     * @param \StructType\XFkType $regionName
     * @param string $bandwidth
     * @param string $videoBandwidth
     * @param string $immersiveVideoBandwidth
     * @param string $lossyNetwork
     * @param \StructType\XFkType $codecPreference
     */
    public function __construct(\StructType\XFkType $regionName = null, $bandwidth = 'G.711', $videoBandwidth = '384', $immersiveVideoBandwidth = '2147483647', $lossyNetwork = null, \StructType\XFkType $codecPreference = null)
    {
        $this
            ->setRegionName($regionName)
            ->setBandwidth($bandwidth)
            ->setVideoBandwidth($videoBandwidth)
            ->setImmersiveVideoBandwidth($immersiveVideoBandwidth)
            ->setLossyNetwork($lossyNetwork)
            ->setCodecPreference($codecPreference);
    }
    /**
     * Get regionName value
     * @return \StructType\XFkType
     */
    public function getRegionName()
    {
        return $this->regionName;
    }
    /**
     * Set regionName value
     * @param \StructType\XFkType $regionName
     * @return \StructType\XRegionRelationship
     */
    public function setRegionName(\StructType\XFkType $regionName = null)
    {
        $this->regionName = $regionName;
        return $this;
    }
    /**
     * Get bandwidth value
     * @return string
     */
    public function getBandwidth()
    {
        return $this->bandwidth;
    }
    /**
     * Set bandwidth value
     * @param string $bandwidth
     * @return \StructType\XRegionRelationship
     */
    public function setBandwidth($bandwidth = 'G.711')
    {
        // validation for constraint: string
        if (!is_null($bandwidth) && !is_string($bandwidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bandwidth, true), gettype($bandwidth)), __LINE__);
        }
        $this->bandwidth = $bandwidth;
        return $this;
    }
    /**
     * Get videoBandwidth value
     * @return string
     */
    public function getVideoBandwidth()
    {
        return $this->videoBandwidth;
    }
    /**
     * Set videoBandwidth value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoBandwidth
     * @return \StructType\XRegionRelationship
     */
    public function setVideoBandwidth($videoBandwidth = '384')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($videoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($videoBandwidth) ? implode(', ', $videoBandwidth) : var_export($videoBandwidth, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->videoBandwidth = $videoBandwidth;
        return $this;
    }
    /**
     * Get immersiveVideoBandwidth value
     * @return string
     */
    public function getImmersiveVideoBandwidth()
    {
        return $this->immersiveVideoBandwidth;
    }
    /**
     * Set immersiveVideoBandwidth value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $immersiveVideoBandwidth
     * @return \StructType\XRegionRelationship
     */
    public function setImmersiveVideoBandwidth($immersiveVideoBandwidth = '2147483647')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($immersiveVideoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($immersiveVideoBandwidth) ? implode(', ', $immersiveVideoBandwidth) : var_export($immersiveVideoBandwidth, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->immersiveVideoBandwidth = $immersiveVideoBandwidth;
        return $this;
    }
    /**
     * Get lossyNetwork value
     * @return string|null
     */
    public function getLossyNetwork()
    {
        return $this->lossyNetwork;
    }
    /**
     * Set lossyNetwork value
     * @uses \EnumType\XLossyNetwork::valueIsValid()
     * @uses \EnumType\XLossyNetwork::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lossyNetwork
     * @return \StructType\XRegionRelationship
     */
    public function setLossyNetwork($lossyNetwork = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XLossyNetwork::valueIsValid($lossyNetwork)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XLossyNetwork', is_array($lossyNetwork) ? implode(', ', $lossyNetwork) : var_export($lossyNetwork, true), implode(', ', \EnumType\XLossyNetwork::getValidValues())), __LINE__);
        }
        $this->lossyNetwork = $lossyNetwork;
        return $this;
    }
    /**
     * Get codecPreference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCodecPreference()
    {
        return isset($this->codecPreference) ? $this->codecPreference : null;
    }
    /**
     * Set codecPreference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $codecPreference
     * @return \StructType\XRegionRelationship
     */
    public function setCodecPreference(\StructType\XFkType $codecPreference = null)
    {
        if (is_null($codecPreference) || (is_array($codecPreference) && empty($codecPreference))) {
            unset($this->codecPreference);
        } else {
            $this->codecPreference = $codecPreference;
        }
        return $this;
    }
}
