<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPhoneLine StructType
 * @subpackage Structs
 */
class XPhoneLine extends AbstractStructBase
{
    /**
     * The index
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $index;
    /**
     * The dirn
     * Meta information extracted from the WSDL
     * - documentation: Only uuid attribute is returned in response
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\XDirn
     */
    public $dirn;
    /**
     * The recordingMediaSource
     * Meta information extracted from the WSDL
     * - default: Gateway Preferred
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $recordingMediaSource;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The display
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $display;
    /**
     * The ringSetting
     * Meta information extracted from the WSDL
     * - default: Ring
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSetting;
    /**
     * The consecutiveRingSetting
     * Meta information extracted from the WSDL
     * - documentation: Consecutive Rings Setting. Replaces the consective ring setting on IPPhone.
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $consecutiveRingSetting;
    /**
     * The ringSettingIdlePickupAlert
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for IP Phones
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ringSettingIdlePickupAlert;
    /**
     * The ringSettingActivePickupAlert
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for IP Phones
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ringSettingActivePickupAlert;
    /**
     * The displayAscii
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $displayAscii;
    /**
     * The e164Mask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $e164Mask;
    /**
     * The mwlPolicy
     * Meta information extracted from the WSDL
     * - default: Use System Policy
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mwlPolicy;
    /**
     * The maxNumCalls
     * Meta information extracted from the WSDL
     * - default: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxNumCalls;
    /**
     * The busyTrigger
     * Meta information extracted from the WSDL
     * - default: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $busyTrigger;
    /**
     * The callInfoDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CallInfoDisplay
     */
    public $callInfoDisplay;
    /**
     * The recordingProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $recordingProfileName;
    /**
     * The monitoringCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $monitoringCssName;
    /**
     * The recordingFlag
     * Meta information extracted from the WSDL
     * - default: Call Recording Disabled
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordingFlag;
    /**
     * The audibleMwi
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for gatewayEndpointAnalogAccess and CiscoCatalyst600024PortFXSGateway
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $audibleMwi;
    /**
     * The speedDial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $speedDial;
    /**
     * The partitionUsage
     * Meta information extracted from the WSDL
     * - documentation: This tag cannot be modified. It can only be specified in the add request.
     * - default: General
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partitionUsage;
    /**
     * The associatedEndusers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AssociatedEndusers
     */
    public $associatedEndusers;
    /**
     * The missedCallLogging
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $missedCallLogging;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for XPhoneLine
     * @uses XPhoneLine::setIndex()
     * @uses XPhoneLine::setDirn()
     * @uses XPhoneLine::setRecordingMediaSource()
     * @uses XPhoneLine::setLabel()
     * @uses XPhoneLine::setDisplay()
     * @uses XPhoneLine::setRingSetting()
     * @uses XPhoneLine::setConsecutiveRingSetting()
     * @uses XPhoneLine::setRingSettingIdlePickupAlert()
     * @uses XPhoneLine::setRingSettingActivePickupAlert()
     * @uses XPhoneLine::setDisplayAscii()
     * @uses XPhoneLine::setE164Mask()
     * @uses XPhoneLine::setMwlPolicy()
     * @uses XPhoneLine::setMaxNumCalls()
     * @uses XPhoneLine::setBusyTrigger()
     * @uses XPhoneLine::setCallInfoDisplay()
     * @uses XPhoneLine::setRecordingProfileName()
     * @uses XPhoneLine::setMonitoringCssName()
     * @uses XPhoneLine::setRecordingFlag()
     * @uses XPhoneLine::setAudibleMwi()
     * @uses XPhoneLine::setSpeedDial()
     * @uses XPhoneLine::setPartitionUsage()
     * @uses XPhoneLine::setAssociatedEndusers()
     * @uses XPhoneLine::setMissedCallLogging()
     * @uses XPhoneLine::setCtiid()
     * @param string $index
     * @param \StructType\XDirn $dirn
     * @param string $recordingMediaSource
     * @param string $label
     * @param string $display
     * @param string $ringSetting
     * @param string $consecutiveRingSetting
     * @param string $ringSettingIdlePickupAlert
     * @param string $ringSettingActivePickupAlert
     * @param string $displayAscii
     * @param string $e164Mask
     * @param string $mwlPolicy
     * @param string $maxNumCalls
     * @param string $busyTrigger
     * @param \StructType\CallInfoDisplay $callInfoDisplay
     * @param \StructType\XFkType $recordingProfileName
     * @param \StructType\XFkType $monitoringCssName
     * @param string $recordingFlag
     * @param string $audibleMwi
     * @param string $speedDial
     * @param string $partitionUsage
     * @param \StructType\AssociatedEndusers $associatedEndusers
     * @param string $missedCallLogging
     * @param int $ctiid
     */
    public function __construct($index = null, \StructType\XDirn $dirn = null, $recordingMediaSource = 'Gateway Preferred', $label = null, $display = null, $ringSetting = 'Ring', $consecutiveRingSetting = 'Use System Default', $ringSettingIdlePickupAlert = 'Use System Default', $ringSettingActivePickupAlert = 'Use System Default', $displayAscii = null, $e164Mask = null, $mwlPolicy = 'Use System Policy', $maxNumCalls = '2', $busyTrigger = '1', \StructType\CallInfoDisplay $callInfoDisplay = null, \StructType\XFkType $recordingProfileName = null, \StructType\XFkType $monitoringCssName = null, $recordingFlag = 'Call Recording Disabled', $audibleMwi = 'Default', $speedDial = null, $partitionUsage = 'General', \StructType\AssociatedEndusers $associatedEndusers = null, $missedCallLogging = 'true', $ctiid = null)
    {
        $this
            ->setIndex($index)
            ->setDirn($dirn)
            ->setRecordingMediaSource($recordingMediaSource)
            ->setLabel($label)
            ->setDisplay($display)
            ->setRingSetting($ringSetting)
            ->setConsecutiveRingSetting($consecutiveRingSetting)
            ->setRingSettingIdlePickupAlert($ringSettingIdlePickupAlert)
            ->setRingSettingActivePickupAlert($ringSettingActivePickupAlert)
            ->setDisplayAscii($displayAscii)
            ->setE164Mask($e164Mask)
            ->setMwlPolicy($mwlPolicy)
            ->setMaxNumCalls($maxNumCalls)
            ->setBusyTrigger($busyTrigger)
            ->setCallInfoDisplay($callInfoDisplay)
            ->setRecordingProfileName($recordingProfileName)
            ->setMonitoringCssName($monitoringCssName)
            ->setRecordingFlag($recordingFlag)
            ->setAudibleMwi($audibleMwi)
            ->setSpeedDial($speedDial)
            ->setPartitionUsage($partitionUsage)
            ->setAssociatedEndusers($associatedEndusers)
            ->setMissedCallLogging($missedCallLogging)
            ->setCtiid($ctiid);
    }
    /**
     * Get index value
     * @return string
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \StructType\XPhoneLine
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($index) ? implode(', ', $index) : var_export($index, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get dirn value
     * @return \StructType\XDirn
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param \StructType\XDirn $dirn
     * @return \StructType\XPhoneLine
     */
    public function setDirn(\StructType\XDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get recordingMediaSource value
     * @return string
     */
    public function getRecordingMediaSource()
    {
        return $this->recordingMediaSource;
    }
    /**
     * Set recordingMediaSource value
     * @uses \EnumType\XPreferredMediaSource::valueIsValid()
     * @uses \EnumType\XPreferredMediaSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordingMediaSource
     * @return \StructType\XPhoneLine
     */
    public function setRecordingMediaSource($recordingMediaSource = 'Gateway Preferred')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPreferredMediaSource::valueIsValid($recordingMediaSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPreferredMediaSource', is_array($recordingMediaSource) ? implode(', ', $recordingMediaSource) : var_export($recordingMediaSource, true), implode(', ', \EnumType\XPreferredMediaSource::getValidValues())), __LINE__);
        }
        $this->recordingMediaSource = $recordingMediaSource;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \StructType\XPhoneLine
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($label) && mb_strlen($label) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get display value
     * @return string|null
     */
    public function getDisplay()
    {
        return $this->display;
    }
    /**
     * Set display value
     * @param string $display
     * @return \StructType\XPhoneLine
     */
    public function setDisplay($display = null)
    {
        // validation for constraint: string
        if (!is_null($display) && !is_string($display)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($display, true), gettype($display)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($display) && mb_strlen($display) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($display)), __LINE__);
        }
        $this->display = $display;
        return $this;
    }
    /**
     * Get ringSetting value
     * @return string|null
     */
    public function getRingSetting()
    {
        return $this->ringSetting;
    }
    /**
     * Set ringSetting value
     * @uses \EnumType\XRingSetting::valueIsValid()
     * @uses \EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSetting
     * @return \StructType\XPhoneLine
     */
    public function setRingSetting($ringSetting = 'Ring')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRingSetting::valueIsValid($ringSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XRingSetting', is_array($ringSetting) ? implode(', ', $ringSetting) : var_export($ringSetting, true), implode(', ', \EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->ringSetting = $ringSetting;
        return $this;
    }
    /**
     * Get consecutiveRingSetting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConsecutiveRingSetting()
    {
        return isset($this->consecutiveRingSetting) ? $this->consecutiveRingSetting : null;
    }
    /**
     * Set consecutiveRingSetting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XRingSetting::valueIsValid()
     * @uses \EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $consecutiveRingSetting
     * @return \StructType\XPhoneLine
     */
    public function setConsecutiveRingSetting($consecutiveRingSetting = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRingSetting::valueIsValid($consecutiveRingSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XRingSetting', is_array($consecutiveRingSetting) ? implode(', ', $consecutiveRingSetting) : var_export($consecutiveRingSetting, true), implode(', ', \EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        if (is_null($consecutiveRingSetting) || (is_array($consecutiveRingSetting) && empty($consecutiveRingSetting))) {
            unset($this->consecutiveRingSetting);
        } else {
            $this->consecutiveRingSetting = $consecutiveRingSetting;
        }
        return $this;
    }
    /**
     * Get ringSettingIdlePickupAlert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRingSettingIdlePickupAlert()
    {
        return isset($this->ringSettingIdlePickupAlert) ? $this->ringSettingIdlePickupAlert : null;
    }
    /**
     * Set ringSettingIdlePickupAlert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XRingSetting::valueIsValid()
     * @uses \EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingIdlePickupAlert
     * @return \StructType\XPhoneLine
     */
    public function setRingSettingIdlePickupAlert($ringSettingIdlePickupAlert = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRingSetting::valueIsValid($ringSettingIdlePickupAlert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XRingSetting', is_array($ringSettingIdlePickupAlert) ? implode(', ', $ringSettingIdlePickupAlert) : var_export($ringSettingIdlePickupAlert, true), implode(', ', \EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        if (is_null($ringSettingIdlePickupAlert) || (is_array($ringSettingIdlePickupAlert) && empty($ringSettingIdlePickupAlert))) {
            unset($this->ringSettingIdlePickupAlert);
        } else {
            $this->ringSettingIdlePickupAlert = $ringSettingIdlePickupAlert;
        }
        return $this;
    }
    /**
     * Get ringSettingActivePickupAlert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRingSettingActivePickupAlert()
    {
        return isset($this->ringSettingActivePickupAlert) ? $this->ringSettingActivePickupAlert : null;
    }
    /**
     * Set ringSettingActivePickupAlert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XRingSetting::valueIsValid()
     * @uses \EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingActivePickupAlert
     * @return \StructType\XPhoneLine
     */
    public function setRingSettingActivePickupAlert($ringSettingActivePickupAlert = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRingSetting::valueIsValid($ringSettingActivePickupAlert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XRingSetting', is_array($ringSettingActivePickupAlert) ? implode(', ', $ringSettingActivePickupAlert) : var_export($ringSettingActivePickupAlert, true), implode(', ', \EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        if (is_null($ringSettingActivePickupAlert) || (is_array($ringSettingActivePickupAlert) && empty($ringSettingActivePickupAlert))) {
            unset($this->ringSettingActivePickupAlert);
        } else {
            $this->ringSettingActivePickupAlert = $ringSettingActivePickupAlert;
        }
        return $this;
    }
    /**
     * Get displayAscii value
     * @return string|null
     */
    public function getDisplayAscii()
    {
        return $this->displayAscii;
    }
    /**
     * Set displayAscii value
     * @param string $displayAscii
     * @return \StructType\XPhoneLine
     */
    public function setDisplayAscii($displayAscii = null)
    {
        // validation for constraint: string
        if (!is_null($displayAscii) && !is_string($displayAscii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayAscii, true), gettype($displayAscii)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($displayAscii) && mb_strlen($displayAscii) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($displayAscii)), __LINE__);
        }
        $this->displayAscii = $displayAscii;
        return $this;
    }
    /**
     * Get e164Mask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getE164Mask()
    {
        return isset($this->e164Mask) ? $this->e164Mask : null;
    }
    /**
     * Set e164Mask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $e164Mask
     * @return \StructType\XPhoneLine
     */
    public function setE164Mask($e164Mask = null)
    {
        // validation for constraint: string
        if (!is_null($e164Mask) && !is_string($e164Mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($e164Mask, true), gettype($e164Mask)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($e164Mask) && mb_strlen($e164Mask) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($e164Mask)), __LINE__);
        }
        if (is_null($e164Mask) || (is_array($e164Mask) && empty($e164Mask))) {
            unset($this->e164Mask);
        } else {
            $this->e164Mask = $e164Mask;
        }
        return $this;
    }
    /**
     * Get mwlPolicy value
     * @return string|null
     */
    public function getMwlPolicy()
    {
        return $this->mwlPolicy;
    }
    /**
     * Set mwlPolicy value
     * @uses \EnumType\XMWLPolicy::valueIsValid()
     * @uses \EnumType\XMWLPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mwlPolicy
     * @return \StructType\XPhoneLine
     */
    public function setMwlPolicy($mwlPolicy = 'Use System Policy')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMWLPolicy::valueIsValid($mwlPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XMWLPolicy', is_array($mwlPolicy) ? implode(', ', $mwlPolicy) : var_export($mwlPolicy, true), implode(', ', \EnumType\XMWLPolicy::getValidValues())), __LINE__);
        }
        $this->mwlPolicy = $mwlPolicy;
        return $this;
    }
    /**
     * Get maxNumCalls value
     * @return string|null
     */
    public function getMaxNumCalls()
    {
        return $this->maxNumCalls;
    }
    /**
     * Set maxNumCalls value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxNumCalls
     * @return \StructType\XPhoneLine
     */
    public function setMaxNumCalls($maxNumCalls = '2')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($maxNumCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($maxNumCalls) ? implode(', ', $maxNumCalls) : var_export($maxNumCalls, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxNumCalls = $maxNumCalls;
        return $this;
    }
    /**
     * Get busyTrigger value
     * @return string|null
     */
    public function getBusyTrigger()
    {
        return $this->busyTrigger;
    }
    /**
     * Set busyTrigger value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $busyTrigger
     * @return \StructType\XPhoneLine
     */
    public function setBusyTrigger($busyTrigger = '1')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($busyTrigger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($busyTrigger) ? implode(', ', $busyTrigger) : var_export($busyTrigger, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->busyTrigger = $busyTrigger;
        return $this;
    }
    /**
     * Get callInfoDisplay value
     * @return \StructType\CallInfoDisplay|null
     */
    public function getCallInfoDisplay()
    {
        return $this->callInfoDisplay;
    }
    /**
     * Set callInfoDisplay value
     * @param \StructType\CallInfoDisplay $callInfoDisplay
     * @return \StructType\XPhoneLine
     */
    public function setCallInfoDisplay(\StructType\CallInfoDisplay $callInfoDisplay = null)
    {
        $this->callInfoDisplay = $callInfoDisplay;
        return $this;
    }
    /**
     * Get recordingProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getRecordingProfileName()
    {
        return isset($this->recordingProfileName) ? $this->recordingProfileName : null;
    }
    /**
     * Set recordingProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $recordingProfileName
     * @return \StructType\XPhoneLine
     */
    public function setRecordingProfileName(\StructType\XFkType $recordingProfileName = null)
    {
        if (is_null($recordingProfileName) || (is_array($recordingProfileName) && empty($recordingProfileName))) {
            unset($this->recordingProfileName);
        } else {
            $this->recordingProfileName = $recordingProfileName;
        }
        return $this;
    }
    /**
     * Get monitoringCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getMonitoringCssName()
    {
        return isset($this->monitoringCssName) ? $this->monitoringCssName : null;
    }
    /**
     * Set monitoringCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $monitoringCssName
     * @return \StructType\XPhoneLine
     */
    public function setMonitoringCssName(\StructType\XFkType $monitoringCssName = null)
    {
        if (is_null($monitoringCssName) || (is_array($monitoringCssName) && empty($monitoringCssName))) {
            unset($this->monitoringCssName);
        } else {
            $this->monitoringCssName = $monitoringCssName;
        }
        return $this;
    }
    /**
     * Get recordingFlag value
     * @return string|null
     */
    public function getRecordingFlag()
    {
        return $this->recordingFlag;
    }
    /**
     * Set recordingFlag value
     * @uses \EnumType\XRecordingFlag::valueIsValid()
     * @uses \EnumType\XRecordingFlag::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordingFlag
     * @return \StructType\XPhoneLine
     */
    public function setRecordingFlag($recordingFlag = 'Call Recording Disabled')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRecordingFlag::valueIsValid($recordingFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XRecordingFlag', is_array($recordingFlag) ? implode(', ', $recordingFlag) : var_export($recordingFlag, true), implode(', ', \EnumType\XRecordingFlag::getValidValues())), __LINE__);
        }
        $this->recordingFlag = $recordingFlag;
        return $this;
    }
    /**
     * Get audibleMwi value
     * @return string|null
     */
    public function getAudibleMwi()
    {
        return $this->audibleMwi;
    }
    /**
     * Set audibleMwi value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $audibleMwi
     * @return \StructType\XPhoneLine
     */
    public function setAudibleMwi($audibleMwi = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($audibleMwi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($audibleMwi) ? implode(', ', $audibleMwi) : var_export($audibleMwi, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->audibleMwi = $audibleMwi;
        return $this;
    }
    /**
     * Get speedDial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpeedDial()
    {
        return isset($this->speedDial) ? $this->speedDial : null;
    }
    /**
     * Set speedDial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $speedDial
     * @return \StructType\XPhoneLine
     */
    public function setSpeedDial($speedDial = null)
    {
        // validation for constraint: string
        if (!is_null($speedDial) && !is_string($speedDial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($speedDial, true), gettype($speedDial)), __LINE__);
        }
        if (is_null($speedDial) || (is_array($speedDial) && empty($speedDial))) {
            unset($this->speedDial);
        } else {
            $this->speedDial = $speedDial;
        }
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return string|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @uses \EnumType\XPartitionUsage::valueIsValid()
     * @uses \EnumType\XPartitionUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partitionUsage
     * @return \StructType\XPhoneLine
     */
    public function setPartitionUsage($partitionUsage = 'General')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPartitionUsage::valueIsValid($partitionUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPartitionUsage', is_array($partitionUsage) ? implode(', ', $partitionUsage) : var_export($partitionUsage, true), implode(', ', \EnumType\XPartitionUsage::getValidValues())), __LINE__);
        }
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
    /**
     * Get associatedEndusers value
     * @return \StructType\AssociatedEndusers|null
     */
    public function getAssociatedEndusers()
    {
        return $this->associatedEndusers;
    }
    /**
     * Set associatedEndusers value
     * @param \StructType\AssociatedEndusers $associatedEndusers
     * @return \StructType\XPhoneLine
     */
    public function setAssociatedEndusers(\StructType\AssociatedEndusers $associatedEndusers = null)
    {
        $this->associatedEndusers = $associatedEndusers;
        return $this;
    }
    /**
     * Get missedCallLogging value
     * @return string|null
     */
    public function getMissedCallLogging()
    {
        return $this->missedCallLogging;
    }
    /**
     * Set missedCallLogging value
     * @param string $missedCallLogging
     * @return \StructType\XPhoneLine
     */
    public function setMissedCallLogging($missedCallLogging = 'true')
    {
        // validation for constraint: string
        if (!is_null($missedCallLogging) && !is_string($missedCallLogging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($missedCallLogging, true), gettype($missedCallLogging)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($missedCallLogging) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $missedCallLogging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($missedCallLogging, true)), __LINE__);
        }
        $this->missedCallLogging = $missedCallLogging;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \StructType\XPhoneLine
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !(is_int($ctiid) || ctype_digit($ctiid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ctiid, true), gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
}
